# coding: utf-8


class Handler(object):

    def action(self, *args, **kwargs):
        raise NotImplementedError


class Event(object):

    field_names = []

    def __init__(self, *args, **kwargs):
        self.fields = {}
        for name, value in zip(self.field_names, args):
            self.fields[name] = value
        for name, value in list(kwargs.items()):
            if name not in self.field_names:
                raise RuntimeError('bad event field %s', name)
            if name in self.fields:
                raise RuntimeError('duplicate value for field', name)
            self.fields[name] = value

    def __iter__(self):
        for name in self.field_names:
            yield self.fields[name]

    def get_human_repr(self):
        feed_id = self.fields.get('feed_id')
        item_no = self.fields.get('item_no')
        comment_id = self.fields.get('comment_id')

        if feed_id and item_no and comment_id:
            return '%s/%s/%s' % (feed_id, item_no, comment_id)
        if feed_id and item_no:
            return '%s/%s' % (feed_id, item_no)
        if feed_id:
            return str(feed_id)
