# -*- coding: utf-8 -*-

from datetime import datetime
import types
import logging

from at.pump.Query import Handler, Event
from at.common.utils import get_connection
from at.common.groups import GroupType
from at.aux_ import Relations


_log = logging.getLogger(__name__)


class SynchronizeMongoFrienderHandler(Handler):
    """Synchronizes out mongodb to f7_XX dbs data of friender notifications."""
    class Event(Event):
        field_names = ['friender_uid', 'friendee_uid']

    def action(self, event):
        return True
        # TODO выкинуть всё это барахло и сделать точечные апдейты в монгу
        friender_uid, friendee_uid = event
        if friender_uid == friendee_uid:
            return True
        sql_query = """SELECT persons.status AS friender_status,
                friender.add_date,
                friendee.fgroup_id,
                unwanted.unwanted_feed_id IS NOT NULL /* friendee marked friender UNWANTED */
            FROM FriendGroupMember friender LEFT JOIN persons
                ON ( friender.person_id = persons.person_id )
                LEFT JOIN FriendGroupMember friendee
                ON ( friendee.person_id = friender.uid AND friendee.uid = friender.person_id )
                LEFT JOIN UnwantedPersons unwanted
                ON ( unwanted.person_id = friender.uid AND unwanted.unwanted_feed_id = friender.person_id )
            WHERE friender.person_id = %s
                AND friender.fgroup_id = 0 /* friender set FRIEND on friendee */
                AND friender.uid = %s /* friendee uid */"""
        # Важно читать их мастера, а не из реплики.
        with get_connection() as connection:
            features = connection.execute(sql_query, (friender_uid, friendee_uid)).fetchall()
        if features:
            frienderStatus, relationTimestamp, _, isFrienderUnwanted = features[0]
            # Can be both FRIEND and BANNED.
            friendee_fgroups = [ fgroup_id for _, _, fgroup_id, _ in features ]
            friendeeAcceptsNotification = GroupType.BANNED not in friendee_fgroups and not isFrienderUnwanted
            isMutualFriend = GroupType.FRIEND in friendee_fgroups
        if features and frienderStatus == 'normal' and friendeeAcceptsNotification and not isMutualFriend:
            update_operation = {'$set': {'state': [],
                'timestamp': datetime.now(),
                'object.timestamp': relationTimestamp } }
            upsert = True
        else:
            update_operation = {'$addToSet': {'state': 'deleted'} }
            upsert = False
        # We use atomic 'insert on duplicate key update'.
        error = FrienderNotification.storage().update(
            {'uid': friendee_uid, 'object.friender_uid': friender_uid },
            update_operation, upsert=upsert, w=2)
        if error['err'] is not None:
            _log.error("Friender notification synchronization failed. Mongo error %r" % (error,))
            return False
        return True


def get_friend_relations_for_person(user_id, relation_handler):
    for friend in Relations.get_relations_multi(None, [user_id], flat=True):
        if friend.role == GroupType.FRIEND:
            relation_handler(user_id, friend.uid)


class UpdateUserEventsAfterBlogStatusChange(Handler):
    """
    Updates relevant mongo notifications when user blog
    freezed/deleted/restored.
    """
    class Event(Event):
        field_names = ['user_id']

    def action(self, event):
        user_id, = event

        def relation_handler(_, friend_uid):
            from at.pump import HandlerRegistry
            HandlerRegistry.put_event(
                'SynchronizeMongoFrienderHandler',
                friender_uid=user_id,
                friendee_uid=friend_uid,
            )
        get_friend_relations_for_person(user_id, relation_handler)
        return True

from at.aux_.UserEvents import FrienderNotification


names = list(locals().keys())
__all__ = [name for name, obj in locals().items() if isinstance(obj, type) and issubclass(obj,
                                                 (Event, Handler))]
