# coding: utf-8

import logging
from string import Template

from django.conf import settings

from at.common.utils import stopwatch
from at.common.utils import get_connection
from at.common.groups import GroupType

_log = logging.getLogger(__name__)


@stopwatch
def update_rating():
    c_groups = ",".join(map(str, [GroupType.OWNER, GroupType.MEMBER, GroupType.MODERATOR]))
    sql = Template('''
    INSERT INTO Communities (feed_id, rating)
        SELECT fgm.person_id, sum(p.qu) AS rating
        FROM FriendGroupMember fgm JOIN persons p ON (fgm.uid = p.person_id)
        WHERE p.status = 'normal' AND fgroup_id IN ($c_groups)
                AND fgm.person_id >= $COMMUNITY_START_ID
        GROUP BY fgm.person_id
    ON DUPLICATE KEY UPDATE rating=VALUES(rating)
    ''').substitute(COMMUNITY_START_ID=settings.COMMUNITY_START_ID, c_groups=c_groups)
    with get_connection() as conn:
        conn.execute(sql)


