# coding: utf-8



from functools import wraps

from celery import shared_task as celery_shared_task

from at.pump.RecentActionHandlers import *
from at.pump.MailHandlers import *
from at.pump.AccessHandlers import *
from at.pump.Mentions import *
from at.pump.Indexing import *
from at.pump.StatHandlers import *
from at.pump.FriendHandlers import *
from at.pump.UserEventHandlers import *
from at.pump.PostFinalizers import *
from at.pump.MailHandlers import MailCantBeSent


def shared_task(fu):
    @celery_shared_task
    @wraps(fu)
    def inner(*args, **kwargs):
        try:
            return fu(*args, **kwargs)
        except MailCantBeSent:
            if settings.CELERY_RESEND_EMAILS:
                # hack. retrying don't work
                globals()[fu.__name__].apply_async(
                    args=args,
                    kwargs=kwargs,
                    countdown=600,
                )
    return inner


# TODO: удалить все хендлеры, переписать таски на celery-функции
# их конечно удобнее было бы сгруппировать по модулям, но пока так.
@shared_task
def handle_delete(*args, **kwargs):
    handler = DeleteHandler
    event = handler.Event(*args, **kwargs)
    return handler().action(event)


@shared_task
def autofriendship_manage(*args, **kwargs):
    handler = AutofriendshipManager
    event = handler.Event(*args, **kwargs)
    return handler().action(event)


@shared_task
def mail_digest(*args, **kwargs):
    handler = MailDigestHandler
    event = handler.Event(*args, **kwargs)
    return handler().action(event)


@shared_task
def handle_like_notification(*args, **kwargs):
    handler = LikeNotificationHandler
    event = handler.Event(*args, **kwargs)
    return handler().action(event)


@shared_task
def club_notify(*args, **kwargs):
    handler = ClubNotifyHandler
    event = handler.Event(*args, **kwargs)
    return handler().action(event)


@shared_task
def deliver_congratulations(*args, **kwargs):
    handler = DeliverCongratulationsHandler
    event = handler.Event(*args, **kwargs)
    return handler().action(event)


@shared_task
def handle_moderate(*args, **kwargs):
    handler = ModerateHandler
    event = handler.Event(*args, **kwargs)
    return handler().action(event)


@shared_task
def mail_new_relation(*args, **kwargs):
    handler = MailNewRelationHandler
    event = handler.Event(*args, **kwargs)
    return handler().action(event)


@shared_task
def autofriend(*args, **kwargs):
    handler = AutofriendingHandler
    event = handler.Event(*args, **kwargs)
    return handler().action(event)


@shared_task
def cleanup_likes(*args, **kwargs):
    handler = CleanupLikesHandler
    event = handler.Event(*args, **kwargs)
    return handler().action(event)


@shared_task
def community_stat(*args, **kwargs):
    handler = CommunityStatHandler
    event = handler.Event(*args, **kwargs)
    return handler().action(event)


@shared_task
def sync_mongo_friender(*args, **kwargs):
    handler = SynchronizeMongoFrienderHandler
    event = handler.Event(*args, **kwargs)
    return handler().action(event)


@shared_task
def undelete_feed(*args, **kwargs):
    handler = UndeleteFeedHandler
    event = handler.Event(*args, **kwargs)
    return handler().action(event)


@shared_task
def modify_comments_counter(*args, **kwargs):
    handler = ModifyCommentsCounterHandler
    event = handler.Event(*args, **kwargs)
    return handler().action(event)


@shared_task
def cleanup_mentions(*args, **kwargs):
    handler = CleanupMentionsHandler
    event = handler.Event(*args, **kwargs)
    return handler().action(event)


@shared_task
def handle_deleted_comment(*args, **kwargs):
    handler = DeletedCommentHandler
    event = handler.Event(*args, **kwargs)
    return handler().action(event)


@shared_task
def score_post(*args, **kwargs):
    handler = ScorePostHandler
    event = handler.Event(*args, **kwargs)
    return handler().action(event)

@shared_task
def change_post_access(*args, **kwargs):
    handler = ChangePostsAccessesHandler
    event = handler.Event(*args, **kwargs)
    return handler().action(event)


@shared_task
def change_post(*args, **kwargs):
    handler = ChangePostAccess
    event = handler.Event(*args, **kwargs)
    return handler().action(event)


@shared_task
def mail_premoderated_post(*args, **kwargs):
    handler = MailPremoderatedPostHandler
    event = handler.Event(*args, **kwargs)
    return handler().action(event)


@shared_task
def handle_summon(*args, **kwargs):
    handler = SummonFinalizeHandler
    event = handler.Event(*args, **kwargs)
    return handler().action(event)


@shared_task
def handle_recent_comments(*args, **kwargs):
    handler = RecentCommentsHandler
    event = handler.Event(*args, **kwargs)
    return handler().action(event)


@shared_task
def cleanup_comment_history(*args, **kwargs):
    handler = CleanupCommentHistoryHandler
    event = handler.Event(*args, **kwargs)
    return handler().action(event)

@shared_task
def handle_unfriend(*args, **kwargs):
    handler = UnfriendHandler
    event = handler.Event(*args, **kwargs)
    return handler().action(event)


@shared_task
def mail_mention(*args, **kwargs):
    handler = MailMentionHandler
    event = handler.Event(*args, **kwargs)
    return handler().action(event)


@shared_task
def push_isearch(*args, **kwargs):
    handler = ISearchHandler
    event = handler.Event(*args, **kwargs)
    return handler().action(event)


@shared_task
def handle_delete_feed(*args, **kwargs):
    handler = DeleteFeedHandler
    event = handler.Event(*args, **kwargs)
    return handler().action(event)


@shared_task
def mail_new_comment(*args, **kwargs):
    handler = MailNewCommentHandler
    event = handler.Event(*args, **kwargs)
    return handler().action(event)


@shared_task
def handle_unfriend(*args, **kwargs):
    handler = UnfriendHandler
    event = handler.Event(*args, **kwargs)
    return handler().action(event)


@shared_task
def mail_mention(*args, **kwargs):
    handler = MailMentionHandler
    event = handler.Event(*args, **kwargs)
    return handler().action(event)


@shared_task
def push_isearch(*args, **kwargs):
    handler = ISearchHandler
    event = handler.Event(*args, **kwargs)
    return handler().action(event)


@shared_task
def handle_delete_feed(*args, **kwargs):
    handler = DeleteFeedHandler
    event = handler.Event(*args, **kwargs)
    return handler().action(event)


@shared_task
def mail_new_comment(*args, **kwargs):
    handler = MailNewCommentHandler
    event = handler.Event(*args, **kwargs)
    return handler().action(event)



@shared_task
def deliver_mentions(*args, **kwargs):
    handler = DeliverMentionsHandler
    event = handler.Event(*args, **kwargs)
    return handler().action(event)


@shared_task
def mail_new_post(*args, **kwargs):
    handler = MailNewPostHandler
    event = handler.Event(*args, **kwargs)
    return handler().action(event)


@shared_task
def club_check(*args, **kwargs):
    handler = ClubCheckHandler
    event = handler.Event(*args, **kwargs)
    return handler().action(event)


@shared_task
def handle_publish(*args, **kwargs):
    handler = PublishHandler
    event = handler.Event(*args, **kwargs)
    return handler().action(event)


@shared_task
def handle_readmitted_feed(*args, **kwargs):
    handler = ReadmittedFeedHandler
    event = handler.Event(*args, **kwargs)
    return handler().action(event)


@shared_task
def handle_edit(*args, **kwargs):
    handler = EditHandler
    event = handler.Event(*args, **kwargs)
    return handler().action(event)

@shared_task
def handle_cc(*args, **kwargs):
    handler = CCFinalizeHandler
    event = handler.Event(*args, **kwargs)
    return handler().action(event)


@shared_task
def insert_recent(*args, **kwargs):
    handler = InsertRecentHandler
    event = handler.Event(*args, **kwargs)
    return handler().action(event)


@shared_task
def handle_blog_status_change(*args, **kwargs):
    handler = UpdateUserEventsAfterBlogStatusChange
    event = handler.Event(*args, **kwargs)
    return handler().action(event)


@shared_task
def handle_premoderate(*args, **kwargs):
    handler = PremoderateHandler
    event = handler.Event(*args, **kwargs)
    return handler().action(event)


@shared_task
def remove_mention_notification(*args, **kwargs):
    handler = RemoveMentionNotificationsHandler
    event = handler.Event(*args, **kwargs)
    return handler().action(event)


@shared_task
def handle_dismissed_feed(*args, **kwargs):
    handler = DismissedFeedHandler
    event = handler.Event(*args, **kwargs)
    return handler().action(event)


@shared_task
def create_digest_events():
    from at.pump import Digest
    Digest.create_digest_events()


@shared_task
def sync_with_staff():
    from at.pump import staff_sync
    staff_sync.sync()


@shared_task
def update_communities_rating():
    from at.pump import communities_rating
    communities_rating.update_rating()
