#!/usr/bin/env python
"""Update automatic friendships according to staff group memberships.

Usage: update_intrafriends.py [-v] [uid] ...
    -v      be verbose and log to stdout instead of a log file.
    uid     update specific user, if no uids specified, update everybody.
"""


import sys
import getopt
import logging

from django.conf import settings
from at.common.utils import get_connection, getAuthInfo
from at.common import intrafriend
# for update_person
from at.pump import FriendHandlers


log = logging.getLogger('scripts.update_intrafriends')


def main():
    opts_list, args = getopt.getopt(sys.argv[1:], 'v')

    if args:
        try:
            to_update = list(map(int, args))
        except ValueError:
            print('uid must be integer', file=sys.stderr)
            sys.exit(1)
    else:
        with get_connection() as conn:
            to_update = (uid for uid, in conn.execute("select person_id from persons where status = 'normal' and person_id < %s", (settings.COMMUNITY_START_ID,)))

    for person_id in to_update:
        try:
            intrafriend.update_person(getAuthInfo(person_id, login='blah'))
        except:
            log.warn('failed to update %s:' % (person_id,), exc_info=1)
        else:
            log.debug('user %s updated okay.' % (person_id,))


if __name__ == '__main__':
    main()
