from ast import literal_eval
import os
import sys
import yenv
import ylog
import datasources_config_wrapper
from django_tools_log_context.settings import *


SECRET_KEY = 'wowsuchsecret'

DEBUG = os.environ.get('DEBUG', '0') == '1'

DEBUG_PROPAGATE_EXCEPTIONS = os.environ.get('DEBUG_PROPAGATE_EXCEPTIONS', False)
DEV_LOGIN = os.environ.get('USER', '')

USE_TZ = True
TIME_ZONE = 'Europe/Moscow'
STATIC_URL = '/static/'

if 'DEPLOY_MODE_API' in os.environ:
    MODE = 'API'
elif 'DEPLOY_MODE_BACKEND' in os.environ:
    MODE = 'BACKEND'
elif 'DEPLOY_MODE_CELERY' in os.environ:
    MODE = 'CELERY'
else:
    MODE = os.environ.get('DEPLOY_MODE', 'BACKEND+API')

AUTH_USER_MODEL = 'aux_.Person'

ROOT_URLCONF = 'at.urls'

TOOLS_LOG_CONTEXT_PROVIDERS = [
    'django_tools_log_context.provider.request',
    'django_tools_log_context.provider.auth',
    'at.common.provider.endpoint',
]

INSTALLED_APPS = [
    'django.contrib.admin',
    # admin deps
    'django.contrib.messages',
    'django.contrib.sessions',
    'django.contrib.staticfiles',

    'django.contrib.contenttypes',  # django yauth imports model
    'django.contrib.auth',  # django yauth imports model
    'django.contrib.sites',  # django yauth imports model

    'django_tools_log_context',
    'django_yauth',
    'at.aux_',
    'at.pump',
    'at.common',
]

if yenv.type == 'development':
    INSTALLED_APPS.append('django_extensions')
    RUNSERVERPLUS_SERVER_ADDRESS_PORT = '0.0.0.0:9100'

from django_yauth.settings import *
from django_alive.settings import *

YAUTH_MECHANISMS = [
    'django_yauth.authentication_mechanisms.tvm',
    'django_yauth.authentication_mechanisms.cookie',
    'django_yauth.authentication_mechanisms.oauth',
]
YAUTH_USE_SITES = False
YAUTH_REFRESH_SESSION = False

MIDDLEWARE_CLASSES = [
    'django_alive.middleware.AliveMiddleware',
    'django_replicated.middleware.ReplicationMiddleware',
    'django.middleware.common.CommonMiddleware',
    'at.common.middleware.DebugMiddleware',
    'django_yauth.middleware.YandexAuthMiddleware',
    'at.common.middleware.AuthInfoMiddleware',
    # for admin
    'django.contrib.sessions.middleware.SessionMiddleware',
    'django.contrib.messages.middleware.MessageMiddleware',
]


if yenv != 'development':
    CACHES = {
        'default': {
            'BACKEND': 'django.core.cache.backends.memcached.MemcachedCache',
            'LOCATION': '127.0.0.1:11211',
        }
    }
else:
    CACHES = {
        'default': {
            'BACKEND': 'django.core.cache.backends.dummy.DummyCache',
        }
    }

ds = datasources_config_wrapper.DatasourcesConfigWrapper(
    prefix='at',
    suppress_warning=True,
    fallback_on_env_vars=True,
)

USER = os.environ.get('USER', 'dummy')
USER_HOME = os.environ.get('HOME')


MYSQL_MASTER_FROM_ENV = os.environ.get('MYSQL_MASTER')
MYSQL_MASTER_FROM_ENV = MYSQL_MASTER_FROM_ENV and MYSQL_MASTER_FROM_ENV.split(':')
MYSQL_MASTER_HOST, MYSQL_MASTER_PORT = MYSQL_MASTER_FROM_ENV or yenv.choose_key_by_type(
    {
        'production': ('c-mdbtljsacga3mch8g9ar.rw.db.yandex.net', 3306),
        'testing': ('c-mdb9sno3qck08kidkbtm.rw.db.yandex.net', 3306),
        'unstable': ('vs-atmysql01e.tools.os.yandex.ru', 3306),
        'development': ('vs-atmysql01e.tools.os.yandex.ru', 3306),
    },
    fallback=True
)

MYSQL_SLAVE_FROM_ENV = os.environ.get('MYSQL_SLAVE')
MYSQL_SLAVE_FROM_ENV = MYSQL_SLAVE_FROM_ENV and MYSQL_SLAVE_FROM_ENV.split(':')
MYSQL_SLAVES_BY_ENV = yenv.choose_key_by_type(
        {
        'production': (
            ('c-mdbtljsacga3mch8g9ar.ro.db.yandex.net', 3306),
        ),
        'testing': (
            ('c-mdb9sno3qck08kidkbtm.ro.db.yandex.net', 3306),
        ),
        'unstable': (('vs-atmysql01e.tools.os.yandex.ru', 3306), ),
        'development': (('vs-atmysql01e.tools.os.yandex.ru', 3306), ),
        },
        fallback=True
    )


if MYSQL_SLAVE_FROM_ENV:
    MYSQL_SLAVE_HOST, MYSQL_SLAVE_PORT = MYSQL_SLAVE_FROM_ENV
    MYSQL_SLAVES_DATA = {
        'slave': {'host': MYSQL_SLAVE_HOST, 'port': MYSQL_SLAVE_PORT, }
    }
else:
    MYSQL_SLAVES_DATA = {
        'slave_{}'.format(i): {'port': port, 'host': host}
        for i, (host, port) in enumerate(MYSQL_SLAVES_BY_ENV)
    }


WRAP_EXCEPTIONS_IN_XML = yenv.choose_key_by_type(
    dict_={
        'production': True,
        # разобраться с косяками в тестах и включить False для тестов
        'development': True,
    },
    fallback=True
    )

if MODE == 'CELERY':
    DEFAULT_CONN_MAX_AGE = '0'
else:
    DEFAULT_CONN_MAX_AGE = '600'


CONN_MAX_AGE = int(os.environ.get('SETTINGS_CONN_MAX_AGE', DEFAULT_CONN_MAX_AGE))

DATABASES = {
    'default': {
        'ENGINE': 'django.db.backends.mysql',
        'HOST': MYSQL_MASTER_HOST,
        'PORT': MYSQL_MASTER_PORT,
        'NAME': 'at',
        'USER': 'at',
        'PASSWORD': ds.mysql_password or 'feedpass',
        'CONN_MAX_AGE': CONN_MAX_AGE,
        'OPTIONS': {
            'connect_timeout': 2,
            'charset': 'utf8mb4',
        },
    },
}

for slave_name, slave_data in MYSQL_SLAVES_DATA.items():
    DATABASES[slave_name] = {
        'ENGINE': 'django.db.backends.mysql',
        'HOST': slave_data['host'],
        'PORT': slave_data['port'],
        'NAME': 'at',
        'USER': 'at',
        'PASSWORD': ds.mysql_password or 'feedpass',
        'CONN_MAX_AGE': CONN_MAX_AGE,
        'OPTIONS': {
            'connect_timeout': 2,
            'charset': 'utf8mb4',
        },
    }

MONGO_DB_NAME = yenv.choose_key_by_type(
    {
        'production': 'atushka',
        'testing': 'at_test',
        'unstable': 'yandex-blogs',
        'development': 'yandex-blogs',
    },
    fallback=True
)
MONGO_REPLICASET = yenv.choose_key_by_type(
    {
        'production': 'rs01',
        'testing': 'rs01',
        'unstable': 'at-dev',
        'development': 'at-dev',
    },
    fallback=True
)
MONGO_HOSTS = yenv.choose_key_by_type(
    {
        'production': [
            'myt-5hr6pys9fmhe59oa.db.yandex.net:27018',
            'sas-llaftgrbg99ia7s2.db.yandex.net:27018',
            'iva-gppghqi32de6nazy.db.yandex.net:27018',
        ],
        'testing': [
            'vla-em91zko9hzefxxvp.db.yandex.net:27018',
            'man-3t1mclgudhmu3j3z.db.yandex.net:27018',
            'sas-9s8h6m5prr1b7wsu.db.yandex.net:27018',
        ],
        'unstable': [
            'vs-atmongo01e.tools.os.yandex.ru:27017',
            'vs-atmongo01e.tools.os.yandex.ru:27018',
        ],
        'development': [
            'vs-atmongo01e.tools.os.yandex.ru:27017',
            'vs-atmongo01e.tools.os.yandex.ru:27018',
        ],
    },
    fallback=True
)

MONGO_USER = yenv.choose_key_by_type(
    {
        'production': 'atushka',
        'testing': 'at_test',
        'unstable': 'at',
        'development': 'at',
    },
    fallback=True
)

MONGO = {
    'hosts': MONGO_HOSTS,
    'repl_set': MONGO_REPLICASET,
    'user': MONGO_USER,
    'password': ds.mongo_password or 'atpwd',
    'database': MONGO_DB_NAME,
    'max_pool_size': 25,
    'network_timeout': 2000,
    'connect_timeout': 1000,
}

OAUTH_ID = '6badbd7219804e74a8d5b8f830be12f6'
OAUTH_SECRET = ds.oauth_secret


XSLT_PATH = '/src/at/common/templates/xslt/'
MAKO_PATH = '/src/at/common/templates/mako/'


TEMPLATES = [
    {
        'BACKEND': 'django.template.backends.django.DjangoTemplates',
        'DIRS': [],
        'APP_DIRS': True,
        'OPTIONS': {
            'context_processors': [
                # for admin
                'django.contrib.auth.context_processors.auth',
                'django.contrib.messages.context_processors.messages',
            ],
        },
    },
]

if yenv.type == 'production':
    AT_MIN_SCORE_FOR_TOP = 10
    AT_INTERESTING_SCORE = 10
    AT_MOST_INTERESTING_SCORE = 30
    AT_INTERESTING_LIFETIME = 3
    AT_MOST_INTERESTING_LIFETIME = 7

    STARTREK_API_URL = 'https://st-api.yandex-team.ru'
    STAFF_API_URL = 'https://staff-api.yandex-team.ru'
    ISEARCH_PUSH_URL = 'https://search-back.yandex-team.ru/api/v1/indexer/at/'
    AVATAR_GET_URL = 'https://avatars-int.mds.yandex.net/get-yablog'
    AVATAR_PUT_URL = 'https://avatars-int.mds.yandex.net:13000/put-yablog'
else:
    AT_MIN_SCORE_FOR_TOP = 1
    AT_INTERESTING_SCORE = 1
    AT_MOST_INTERESTING_SCORE = 2
    AT_INTERESTING_LIFETIME = 1
    AT_MOST_INTERESTING_LIFETIME = 2

    STARTREK_API_URL = 'https://st-api.test.yandex-team.ru'
    STAFF_API_URL = 'https://staff-api.test.yandex-team.ru'
    ISEARCH_PUSH_URL = 'https://search-back.test.yandex-team.ru/api/v1/indexer/at/'
    AVATAR_GET_URL = 'https://avatars-int.mdst.yandex.net/get-yablog'
    AVATAR_PUT_URL = 'https://avatars-int.mdst.yandex.net:13000/put-yablog'

AT_SCHEME = 'https'
if yenv.type == 'production':
    AT_HOST = 'at.yandex-team.ru'
elif yenv.type == 'testing':
    AT_HOST = 'at.test.tools.yandex-team.ru'
else:
    AT_HOST = USER + '.at.unstable.tools.yandex-team.ru'
AT_URL = AT_SCHEME + '://' + AT_HOST


BROKER_URL = 'mongodb://{user}:{password}@{host}/{database}'.format(
    user=MONGO['user'],
    password=MONGO['password'],
    host=','.join(MONGO['hosts']),
    database=MONGO['database'],
)

CELERY_ACCEPT_CONTENT = ['json', 'pickle']
CELERY_TASK_SERIALIZER = 'pickle'

if 'CELERY_ALWAYS_EAGER' in os.environ:
    CELERY_ALWAYS_EAGER = True
else:
    CELERY_ALWAYS_EAGER = yenv.type == 'development'


CELERY_RESEND_EMAILS = os.getenv('CELERY_RESEND_EMAILS', 'True') == 'True'

CELERYD_MAX_TASKS_PER_CHILD = 100

CELERYD_HIJACK_ROOT_LOGGER = False


from celery.schedules import crontab


CELERYBEAT_SCHEDULE = {
    'create_digest_events': {
        'task': 'at.pump.tasks.create_digest_events',
        'schedule': crontab(minute=0, hour=5),
    },
    'sync_with_staff': {
        'task': 'at.pump.tasks.sync_with_staff',
        'schedule': crontab(minute=0, hour=1),
    },
    'update_communities_rating': {
        'task': 'at.pump.tasks.update_communities_rating',
        'schedule': crontab(minute='*/15'),
    },
}

if yenv.type == 'development':
    SKIP_EMAIL_HANDLING = True
else:
    SKIP_EMAIL_HANDLING = False

STAFF_LOAD_LIMIT = os.environ.get('STAFF_LOAD_LIMIT', 500)

UNDEFINED_COMMENT_ID = 4294967295
COMMUNITY_START_ID = 4611686018427387904
UNDEFINED_POST_ID = 18446744073709551615
GODMODE_UID = 18070344

ROBOT_ATUSHKA_UID = 1120000000025361
ROBOT_UID = ROBOT_ATUSHKA_UID
ROBOT_OAUTH_TOKEN = os.environ.get('ROBOT_OAUTH_TOKEN')

RESIZER_URL = 'https://resize.yandex-team.ru'
INFLECTOR_URL = 'http://reqwizard.yandex.net:8891/wizard'

if yenv.type != 'production':
    RESIZER_URL = 'http://resize.yandex.net'
    INFLECTOR_URL = 'http://hamzard.yandex.net:8891/wizard'

MAX_MEMBERS_CLUB_DELETE = 50

ENGLISH_MLS = [
    'turkey@yandex-team.ru',
    'mag-en@yandex-team.ru',
    'ya-logs-digest@yandex-team.ru'
]

# api settings
if yenv.type == 'production':
    CLUB_URL = "http://clubs.at.yandex-team.ru/%(login)s"
    CLUB_POST = "http://clubs.at.yandex-team.ru/%(login)s/%(item_no)s"
    BLOG_POST = "http://%(login)s.at.yandex-team.ru/%(item_no)s"

    CLUB_COMMENT = "http://clubs.at.yandex-team.ru/%(login)s/%(item_no)s/%(comment_id)s"
    BLOG_COMMENT = "http://%(login)s.at.yandex-team.ru/%(item_no)s/%(comment_id)s"
else:
    CLUB_URL = "http://clubs.at.test.tools.yandex-team.ru/%(login)s"
    CLUB_POST = "http://clubs.at.test.tools.yandex-team.ru/%(login)s/%(item_no)s"
    BLOG_POST = "http://%(login)s.at.test.tools.yandex-team.ru/%(item_no)s"

    CLUB_COMMENT = "http://clubs.at.test.tools.yandex-team.ru/%(login)s/%(item_no)s/%(comment_id)s"
    BLOG_COMMENT = "http://%(login)s.at.test.tools.yandex-team.ru/%(item_no)s/%(comment_id)s"


FOTKI_URL_PREFIX = 'http://fotki.yandex.ru/'
VIDEO_URL_PREFIX = 'http://flv.video.yandex.ru/lite/'
VERBOSE_USERPIC_URL_PREFIX = 'http://avatars.yandex.net/get-avatar/'

ALLOWED_HOSTS = [
    '.yandex-team.ru',
    '.yandex.net',
    '.yandex.ru',
]

if yenv.type == 'development':
    UPICS_URL_PREFIX = "http://upics.yandex.net/get/"
else:
    UPICS_URL_PREFIX = "http://upics.yandex.net/"

BLOGS_PERSON_PROFILE_PAGE_URL = "http://{login}.at.yandex-team.ru"

if yenv.type != 'development':
    EMAIL_BACKEND = 'django.core.mail.backends.smtp.EmailBackend'
    EMAIL_HOST = 'outbound-relay.yandex.net'
    EMAIL_PORT = '25'
else:
    EMAIL_BACKEND = 'django.core.mail.backends.console.EmailBackend'
EMAIL_TIMEOUT = 10

# fuck you, Django logging
LOGGING_CONFIG = None

PROJECT_NAME = 'at'


LOG_FORMAT = os.environ.get('QLOUD_LOGGER_STDOUT_PARSER', 'default')


LOGGING = {
    'version': 1,
    'disable_existing_loggers': False,
    'formatters': {
        'default': {
            '()': 'ylog.context.ContextFormatter',
            'datefmt': '%Y-%m-%d %H:%M:%S',
            'format': '[%(asctime)s][%(name)s] - %(levelname)s - %(message)s',
        },
        'json': {
            '()': 'ylog.format.QloudJsonFormatter',
         },
    },
    'handlers': {
        'stdout': {
            'class': 'logging.StreamHandler',
            'formatter': LOG_FORMAT,
            'stream': sys.stdout,
        },
        'stderr': {
            'class': 'logging.StreamHandler',
            'formatter': LOG_FORMAT,
            'stream': sys.stderr,
        },
    },
    'loggers': {
        'celery.worker.consumer': {
            'handlers': ['stdout'],
            'level': 'WARN',
            'propagate': False,
        },
        'at': {
            'handlers': ['stderr'],
            'propagate': False,
            'level': 'WARNING',
        },
        'requests': {
            'handlers': ['stdout'],
            'propagate': False,
            'level': 'INFO',
        },
        'django': {
            'handlers': ['stdout'],
            'propagate': False,
            'level': 'WARNING',
        },
    },
    'root': {
        'handlers': ['stdout'],
        'level': 'INFO',
    },
}


for env_logger_name, env_logger_level in os.environ.items():
    if not env_logger_name.startswith('LOGGER_'):
        continue

    logger_name = env_logger_name[len('LOGGER_'):].lower()
    logger_name = logger_name.replace('__', '.')
    LOGGING['loggers'][logger_name] = {
        'handlers': ['stdout'],
        'propagate': False,
        'level': env_logger_level,
    }


import logging.config
logging.config.dictConfig(LOGGING)

ADMINS = (
    'avrudakova',
    'printsesso',
    'smiryagin',
    'sibirev',
    'shigarus',
    'ljql',
    'theigel',
)


from django_replicated.settings import *

REPLICATED_DATABASE_SLAVES = list(MYSQL_SLAVES_DATA.keys())
DATABASE_ROUTERS = ['django_replicated.router.ReplicationRouter']
REPLICATED_DATABASE_DOWNTIME = int(os.environ.get('SETTINGS_REPLICATED_DATABASE_DOWNTIME', 0))
REPLICATED_CHECK_STATE_ON_WRITE = os.environ.get('SETTINGS_REPLICATED_CHECK_STATE_ON_WRITE', 'true') == 'true'
REPLICATED_FORCE_MASTER_COOKIE_STATUS_CODES = (302, 303, 201)

# django admin forces master on read sometimes
# https://github.com/django/django/blob/c0d968ea1fe8a564199048e4c0083bc559a037bb/django/contrib/admin/options.py#L1449
REPLICATED_VIEWS_OVERRIDES = {
    '/admin/*': 'master',
}
YAUTH_TVM2_CLIENT_ID = ds.tvm2_client_id
YAUTH_TVM2_SECRET = ds.tvm2_secret
YAUTH_TVM2_ALLOWED_CLIENT_IDS = [int(i) for i in ds.tvm2_allowed_clients.split(',')] if ds.tvm2_allowed_clients else []
YAUTH_USE_TVM2_FOR_BLACKBOX = True
YAUTH_TVM2_GET_USER_TICKET = True

TVM2_CLIENTS_MAP = {
    'testing': {
        'tracker': '177',
        'search': '2001037',
        'staff': '2001976',
    },
    'production': {
        'tracker': '176',
        'search': '2001043',
        'staff': '2001974',
    },
}

TVM2_CLIENTS = yenv.choose_key_by_type(TVM2_CLIENTS_MAP)
TVM2_DESTINATIONS = list(TVM2_CLIENTS.values())
TVM_EXCLUDE_PATHS = [
    '/ping/',
    '/time/',
    '/admin/',
    '/static/',
    '/media/',
    '/__debug__/',
    '/tracker/',
]

TVM_TICKET_REQUIRED = os.environ.get('TVM_TICKET_REQUIRED', False)

TVM_DEBUG = os.environ.get('DJANGO_TVM_DEBUG', False)
TVM_ENABLED = os.environ.get('DJANGO_TVM_ENABLED', False)

if TVM_DEBUG:
    MIDDLEWARE_CLASSES += [
        'at.common.middleware.TVMDebugMiddleware',
    ]
elif TVM_ENABLED:
    MIDDLEWARE_CLASSES += [
        'at.common.middleware.TVMMiddleware',
    ]

ENABLE_AUTOFRIEND = os.environ.get("ENABLE_AUTOFRIEND", False)

# sender
SENDER_HOST = os.environ.get('SENDER_HOST', 'https://test.sender.yandex-team.ru')
SENDER_AUTHORIZATION_KEY = os.environ.get('SENDER_AUTHORIZATION_KEY', 'not_used')
VERIFY_SENDER_HOST = os.environ.get('VERIFY_SENDER_HOST', True)
SENDER_ACCOUNT_SLUG = os.environ.get('SENDER_ACCOUNT_SLUG', 'not_used')

SENDER_ROBOT = os.environ.get('SENDER_ROBOT', 'robot-atushka')
SENDER_ROBOT_EMAIL = os.environ.get('SENDER_ROBOT_EMAIL', f'{SENDER_ROBOT}@yandex-team.ru')

SENDER_ENABLED = os.environ.get('SENDER_ENABLED', True)
MAILING_TEMPLATES = literal_eval(os.environ.get('MAILING_TEMPLATES', '{}'))
