from datetime import datetime

from django.views.generic import View
from django.http import JsonResponse

from at.common import utils
from at.common.models import Posts

SCOPE = {
    'interesting': 'store_time_interesting_usec',
    'most': 'store_time_most_interesting_usec'
}


class UnistatView(View):
    """
    Возвращает следующие данные:
    - разницу в минутах между текущим временем и датой скоринга поста в самом
    интересном и интересном

    В выходные и в промежутке с 20 до 12 возвращает 0
    """
    def get(self, *args, **kwargs):
        data = [
            ("most_intresting_delta_ahhh", self._get_interesting_delta(SCOPE['most'])),
            ("intresting_delta_ahhh", self._get_interesting_delta(SCOPE['interesting'])),

        ]
        return JsonResponse(data=data, safe=False)

    def _non_working_hours(self):
        now = datetime.now()
        day_number = now.weekday()
        hour = now.hour
        return day_number >= 5 or hour < 12 or hour > 20

    def _get_interesting_delta(self, scope):
        if self._non_working_hours():
            return 0
        top_time = Posts.objects.order_by('-{}'.format(scope)).values_list(scope, flat=True).first()
        current_time = utils.usec()
        return (current_time-top_time) / 60000000

