# coding: utf-8

import os

from django_tools_log_context.wsgi import log_context_get_wsgi_application

os.environ.setdefault("DJANGO_SETTINGS_MODULE", "at.settings")

QLOUD_ENVIRONMENT = os.environ.get('QLOUD_ENVIRONMENT')
if 'YENV_TYPE' not in os.environ and QLOUD_ENVIRONMENT is not None:
    if '-' in QLOUD_ENVIRONMENT:
        # for env names like testing-one and production-something
        yenv_type = QLOUD_ENVIRONMENT.split('-')[0]
    else:
        yenv_type = QLOUD_ENVIRONMENT
    os.environ['YENV_TYPE'] = yenv_type
os.environ['YENV_NAME'] = 'intranet'

application = log_context_get_wsgi_application()


import uwsgidecorators


@uwsgidecorators.postfork
def warm_up():
    """
    На первый запрос все воркеры тормозят, потому первый импорт этушки
    по каким-то причинам занимает 200-300ms и я не смог найти причину.
    Пока делаем в неком роде прогрев, импортим все сразу после форка процесса.
    """
    from at import urls
