#!/usr/bin/env node
const { wikiToMd } = require('@yandex-data-ui/wiki-yfm-converter');
const transform = require('@doc-tools/transform');
const [, , rawContent] = process.argv;

try {
    const yfmContent = wikiToMd(rawContent);
    const { result, logs } = transform(yfmContent, {});

    if (logs.error && logs.error.length) {
        throw new Error(logs.error.join('\n\n'));
    }

    process.stdout.write(result.html);
} catch (err) {
    console.error(err);
    process.exit(1);
}
