# coding: utf-8
import os

from fabric.api import env, task, local

from robe.venv import create, activate

env.robe.projects = {'at': {}}
env.robe.venv.pip_version = '9.0.1'
env.robe.venv.quiet_install = False
env.robe.venv.requirements_file = 'deps/python-main.txt'
env.robe.venv.dev_requirements_file = 'deps/python-dev.txt'


USER_CFG = os.environ.get('CFG', os.environ.get('USER'))


@task
def venv(mode='dev', *args, **kwargs):
    create(mode, *args, **kwargs)


@task
def test(mode='dev', options='-k "not integrational"'):
    with activate(mode=mode):
        local('py.test tests ' + options)


@task
def changelog():
    local('git add debian/changelog')
    local('debcommit -r')


@task
def release(with_tests='yes'):
    if with_tests == 'yes':
        test(mode='dev')

    build()
    push()
    deploy()



@task
def build():
    local('releaser build --version=latest')


@task
def build_dev():
    local('releaser build --version=latest --image=at-back-dev -fdev.Dockerfile')


@task
def run_dev(cmd='', opts=''):
    build_dev()
    local(' '.join([
        'docker run',
        '-it --rm',
        '-v ~/dev/at-back/at/:/src/at/',
        opts,
        'registry.yandex.net/tools/at-back-dev',
        cmd,
    ]))


@task
def push():
    local('releaser push --version=latest')


@task
def runserver():
    log_context = [
        ('request.id', '%(request.id)'),
        ('profiling_uuid', '%(profiling_uuid)'),
        ('endpoint.name', '%(endpoint.name)'),
        ('user.uid', '%(user.uid)'),
        ('user.email', '%(user.email)'),
        ('auth.mechanism', '%(auth.mechanism)'),
    ]
    command_args = {
        'yenv_name': 'intranet',
        'log_context': '; '.join('%s=%s' % pair for pair in log_context),
    }
    command = (
        'YENV_NAME={yenv_name} uwsgi '
        '--http-socket="[::]:80" '
        '--memory-report '
        '--buffer-size=32000 '
        '--reload-on-as=5000 '
        '--chmod-socket=777 '
        '--module=at.wsgi:application '
        '--processes=1 '
        '--honour-stdin '
        '--py-autoreload=1 '
        '--enable-threads '
        '--log-date="%Y-%m-%d %H:%M:%S," '
        '--logformat-strftime '
        '--logformat="[%(ftime)][uwsgi] - INFO - %(method): %(uri) returned %(status) in %(msecs) msec" '
    ).format(**command_args)
    local(command)
