from django.utils.translation import ugettext_lazy as _

from intranet.audit.src.api_v1.errors import BadRequestError


def get_first_file_from_request(request):
    """
    Вернуть первый файл из объекта HttpRequest.

    Вспомогательная функция. Если файлов нет, бросит исключение.

    @type request: HttpRequest
    @rtype: UploadedFile
    """
    # в запросе должен присутствовать хотя бы один файл
    try:
        first_file = next(request.FILES.values())
    except StopIteration:
        message = _('You should pass file in request')
        raise BadRequestError(message)

    return first_file
