from rest_framework import filters


class RelatedOrderingFilter(filters.OrderingFilter):
    """
    See: https://github.com/tomchristie/django-rest-framework/issues/1005
    Extends OrderingFilter to support ordering by fields in related models
    using the Django ORM __ notation
    """
    def remove_invalid_fields(self, queryset, fields, ordering, view):
        return fields
