from rest_framework import serializers

from intranet.audit.src.api_v1.serializers.base import BaseSerializer
from intranet.audit.src.core import models


class ParentAccountSerializer(BaseSerializer):

    parent = serializers.SlugRelatedField(
        read_only=True,
        slug_field='name',
    )

    class Meta:
        model = models.Account
        fields = (
            'id',
            'name',
            'parent',
        )


class AccountSerializer(BaseSerializer):

    @property
    def fields(self):
        fields = super().fields
        fields['parent_data'] = ParentAccountSerializer(
            read_only=True,
            source='parent',
        )
        return fields

    class Meta:
        model = models.Account
        fields = (
            'id',
            'name',
            'parent',
            'actions',
        )
