from rest_framework import serializers

from .filter_fields import FieldsFilterMixin


ACTIONS = ('change', 'delete',)


class ActionsField(serializers.Field):

    def __init__(self, **kwargs):
        kwargs['source'] = '*'
        kwargs['read_only'] = True
        super(ActionsField, self).__init__(**kwargs)

    def to_representation(self, obj):
        user = self.root.context.get('user')
        if user:
            model_name = obj._meta.model_name
            model_app = obj._meta.app_label
            return {
                action: user.has_perm('{}.{}_{}'.format(model_app, action, model_name), obj)
                for action in ACTIONS
            }
        return {}


class BaseSerializer(FieldsFilterMixin, serializers.ModelSerializer):
    actions = ActionsField()

    def create(self, validated_data):
        validated_data['author'] = self.context['request'].user
        return super().create(validated_data)
