class FieldsFilterMixin:
    def __init__(self, *args, **kwargs):
        super().__init__(*args, **kwargs)
        request = self.context.get('request')
        self.fields_from_request = None
        if request:
            fields = request.query_params.get('fields')
            if fields:
                fields = {field_name
                          for field in fields.split(',')
                          for field_name in (field, '{}_data'.format(field))
                          }
                existing = set(self.fields.keys())
                self.fields_from_request = fields
                for field_name in existing - fields:
                    self.fields.pop(field_name)
