import collections

from rest_framework.fields import empty

from intranet.audit.src.users.logic.user import already_created
from intranet.audit.src.users.dao.user import get_stated_persons_by_uids_from_staff
from intranet.audit.src.core.logic.form import update_form_data, prepare_form_data


class StatedPersonCreationMixin:
    """
    Создает объекты StatedPerson и подменяет id на нужные в POST/PUT данных

    Перенес код из админки, с фронта нам прилетают uid пользователей
    получаем по ним информацию и сохраняем новые объекты StatedPerson
    если не существует уже созданных совпадающих
    """
    PERSONS_ATTRIBUTE_NAMES = 'owner',

    def run_validation(self, data=empty):
        (is_empty_value, data) = self.validate_empty_values(data)
        if is_empty_value:
            return data

        ids_data = collections.defaultdict(set)
        for attr_name in self.PERSONS_ATTRIBUTE_NAMES:
            stated_person_data = [str(uid) for uid in data.get(attr_name, [])]
            if len(stated_person_data) > 0:
                data[attr_name] = stated_person_data
                for uid in stated_person_data:
                    if not already_created(uid):
                        ids_data[uid].add(attr_name)
        ids = [uid for uid in ids_data]

        if ids:
            users = get_stated_persons_by_uids_from_staff(*ids, request=self.context['request'])
            prepare_form_data(self.PERSONS_ATTRIBUTE_NAMES, data)
            update_form_data(ids_data, users, data)
        return super().run_validation(data=data)
