from .base import BaseSerializer, StatedPersonCreationMixin

from .process import ProcessSerializer
from .legal import LegalSerializer
from .service import ServiceSerializer
from .system import SystemSerializer
from .risk import RiskSerializer
from .control import ControlSerializer
from .account import AccountSerializer
from .businessunit import BusinessUnitSerializer
from .assertion import AssertionSerializer
from .statedperson import StatedPersonSerializer

from intranet.audit.src.core import models


class ControlPlanSerializer(StatedPersonCreationMixin, BaseSerializer):
    PERSONS_ATTRIBUTE_NAMES = 'owner', 'reviewer',

    process_data = ProcessSerializer(read_only=True, many=True, source='process', )
    service_data = ServiceSerializer(read_only=True, many=True, source='service', )
    account_data = AccountSerializer(read_only=True, many=True, source='account', )
    system_data = SystemSerializer(read_only=True, many=True, source='system', )

    legal_data = LegalSerializer(read_only=True, many=True, source='legal', )
    owner_data = StatedPersonSerializer(read_only=True, many=True, source='owner', )
    risk_data = RiskSerializer(read_only=True, many=True, source='risk', )
    control_data = ControlSerializer(read_only=True, source='control', )
    assertion_data = AssertionSerializer(read_only=True, many=True, source='assertion', )
    business_unit_data = BusinessUnitSerializer(read_only=True, many=True, source='business_unit', )
    reviewer_data = StatedPersonSerializer(read_only=True, many=True, source='reviewer', )

    class Meta:
        model = models.ControlPlan
        fields = [
            'id',
            'process',
            'process_data',
            'service',
            'service_data',
            'system',
            'system_data',
            'risk',
            'risk_data',
            'control',
            'control_data',
            'account',
            'account_data',
            'legal',
            'legal_data',
            'business_unit',
            'business_unit_data',
            'assertion',
            'assertion_data',
            'owner',
            'owner_data',
            'evidence',
            'regulation',
            'control',
            'control_data',
            'key_control',
            'comment',
            'method',
            'frequency',
            'control_type',
            'description',
            'test_period_started',
            'test_period_finished',
            'antifraud',
            'reviewer_data',
            'reviewer',
            'status',
        ]

    def validate(self, attrs):
        if attrs.get('test_period_finished') is not None:
            attrs['status'] = models.ControlPlan.STATUSES.archived
        return super().validate(attrs)
