from .base import BaseSerializer
from .file import FileSerializer
from intranet.audit.src.core import models


class ControlStepSerializer(BaseSerializer):
    class Meta:
        model = models.ControlStep
        fields = 'id', 'step', 'comment', 'result',


class ControlStepDetailSerializer(BaseSerializer):
    file_data = FileSerializer(read_only=True, many=True, source='file',)

    class Meta:
        model = models.ControlStep
        fields = ('id', 'step', 'comment', 'result',
                  'control_test', 'file', 'file_data',
                  )
