from .base import BaseSerializer, StatedPersonCreationMixin, ObjectWithAuthorSerializer
from .file import FileSerializer
from .statedperson import StatedPersonSerializer
from .controlplan import ControlPlanSerializer
from .deficiency import DeficiencyForControlTestSerializer
from .controlstep import ControlStepSerializer, ControlStepDetailSerializer
from .ipe import IPESerializer
from intranet.audit.src.core import models


class ControlTestIPEForControlTestSerializer(ObjectWithAuthorSerializer):
    ipe_data = IPESerializer(read_only=True, source='ipe', )
    attach_data = FileSerializer(read_only=True, many=True, source='attach', )

    class Meta:
        model = models.ControlTestIPE
        fields = (
            'id',
            'status',
            'report_parameters',
            'attach',
            'ipe',
            'control_test',
            'ipe_data',
            'created',
            'modified',
            'attach_data',
        )
        read_only_fields = ('created', 'modified')


class ControlTestForDeficiencySerializer(StatedPersonCreationMixin, BaseSerializer):
    PERSONS_ATTRIBUTE_NAMES = 'tester', 'reviewer',

    control_plan_data = ControlPlanSerializer(read_only=True, source='control_plan',)
    tester_data = StatedPersonSerializer(read_only=True, many=True, source='tester',)
    evidence_data = FileSerializer(read_only=True, many=True, source='evidence',)
    controlstep_set_data = ControlStepSerializer(read_only=True, many=True, source='controlstep_set',)
    reviewer_data = StatedPersonSerializer(read_only=True, many=True, source='reviewer', )

    class Meta:
        model = models.ControlTest
        fields = (
            'id',
            'test_period_started',
            'test_period_finished',
            'testing_date',
            'sampling',
            'evidence_comments',
            'design_efficiency',
            'operational_efficiency',
            'comment',
            'control_plan',
            'control_plan_data',
            'tester',
            'tester_data',
            'evidence',
            'evidence_data',
            'controlstep_set',
            'controlstep_set_data',
            'status',
            'reviewer',
            'reviewer_data',
        )


class ControlTestSerializer(ControlTestForDeficiencySerializer):
    deficiency_data = DeficiencyForControlTestSerializer(read_only=True, many=True, source='deficiency')

    class Meta(ControlTestForDeficiencySerializer.Meta):
        fields = ControlTestForDeficiencySerializer.Meta.fields + (
            'deficiency',
            'deficiency_data',
            'review_date',
            'adjusted_risk',
            'mrc',
            'roll_forward',
            'threshold_for_investigation',
            'how_precision_is_affected',
            'how_management_identifies',
        )


class ControlTestDetailSerializer(ControlTestSerializer):
    controlstep_set_data = ControlStepDetailSerializer(read_only=True, many=True, source='controlstep_set', )
    control_test_ipe_data = ControlTestIPEForControlTestSerializer(read_only=True, many=True, source='control_test_ipe', )

    class Meta:
        model = models.ControlTest
        fields = ControlTestSerializer.Meta.fields + ('control_test_ipe', 'control_test_ipe_data',)
