from .base import BaseSerializer
from .ipe import IPESerializer
from .file import FileSerializer
from intranet.audit.src.core import models


class ControlTestForControlTestIPESerializer(BaseSerializer):
    class Meta:
        model = models.ControlTest
        fields = ('id', 'test_period_started', 'test_period_finished',
                  'testing_date', 'sampling', 'evidence_comments', 'design_efficiency',
                  'operational_efficiency', 'comment',
                  )


class ControlTestIPESerializer(BaseSerializer):
    ipe_data = IPESerializer(read_only=True, source='ipe', )
    attach_data = FileSerializer(read_only=True, many=True, source='attach', )

    class Meta:
        model = models.ControlTestIPE
        fields = ('id', 'status', 'report_parameters',
                  'attach', 'ipe', 'control_test',
                  'created', 'modified', 'ipe_data',
                  'attach_data',
                  )

        read_only_fields = 'created', 'modified',


class ControlTestIPEDetailSerializer(ControlTestIPESerializer):
    control_test_data = ControlTestForControlTestIPESerializer(read_only=True, source='control_test', )

    class Meta:
        model = models.ControlTestIPE
        fields = ControlTestIPESerializer.Meta.fields + ('control_test_data', )
