from .base import ObjectWithAuthorSerializer
from intranet.audit.src.core import models


class DeficiencyForControlTestSerializer(ObjectWithAuthorSerializer):
    class Meta:
        model = models.Deficiency
        fields = (
            'id',
            'short_description',
            'full_description',
            'state',
            'ticket_key',
            'potential_impact',
            'misstatement_probability',
            'mitigating_factors',
            'significance_evaluation',
            'comment',
            'estimate_closing_date',
            'author',
            'created',
            'modified',
            'root_cause_of_the_control_deficiency',
            'internal_control_component',
            'need_to_be_aggregated',
            'indication_of_other_deficiencies',
            'factors_in_evaluating_severity',
            'application_controls',
            'impact_of_gitc_deficiency',
        )

        read_only_fields = (
            'created',
            'modified',
        )


class DeficiencySerializer(DeficiencyForControlTestSerializer):

    @property
    def fields(self):
        from .controltest import ControlTestForDeficiencySerializer
        fields = super().fields
        if not self.fields_from_request or 'control_test' in self.fields_from_request:
            fields['control_test_data'] = ControlTestForDeficiencySerializer(
                read_only=True,
                many=True,
                source='control_test',
            )
        return fields

    class Meta(DeficiencyForControlTestSerializer.Meta):
        fields = DeficiencyForControlTestSerializer.Meta.fields + ('control_test', )
