from intranet.audit.src.api_v1.serializers import DeficiencySerializer
from intranet.audit.src.api_v1.serializers.base import ObjectWithAuthorSerializer
from intranet.audit.src.core import models


class DeficiencyGroupSerializer(ObjectWithAuthorSerializer):

    deficiencies_data = DeficiencySerializer(
        read_only=True,
        many=True,
        source='deficiencies',
    )

    class Meta:
        model = models.DeficiencyGroup
        fields = (
            'id',
            'full_description',
            'state',
            'potential_impact',
            'misstatement_probability',
            'mitigating_factors',
            'significance_evaluation',
            'comment',
            'estimate_closing_date',
            'author',
            'created',
            'modified',
            'deficiencies',
            'deficiencies_data',
        )
        read_only_fields = (
            'created',
            'modified',
        )
