from .base import BaseSerializer
from intranet.audit.src.files import models


class FileSerializer(BaseSerializer):
    class Meta:
        model = models.File
        fields = 'id', 'name', 'size', 'file_link_url',


class FileDetailSerializer(BaseSerializer):
    class Meta:
        model = models.File
        fields = 'id', 'name', 'size', 'file_link_url', 'file', 'content_type',
        read_only_fields = 'name', 'size', 'content_type',
        extra_kwargs = {
            'file': {'write_only': True},
        }
