from .base import ObjectWithAuthorSerializer, StatedPersonCreationMixin
from .file import FileSerializer
from intranet.audit.src.core import models
from .system import SystemSerializer
from .statedperson import StatedPersonSerializer


class ControlTestIPEForIPESerializer(ObjectWithAuthorSerializer):

    @property
    def fields(self):
        from .controltest import ControlTestSerializer
        fields = super().fields
        if not self.fields_from_request or 'control_test' in self.fields_from_request:
            fields['control_test_data'] = ControlTestSerializer(read_only=True,
                                                                source='control_test',
                                                                )
        return fields

    class Meta:
        model = models.ControlTestIPE
        fields = ('id', 'status', 'report_parameters',
                  'attach', 'ipe', 'control_test',
                  'created', 'modified',
                  )
        read_only_fields = 'created', 'modified',


class IPESerializer(StatedPersonCreationMixin, ObjectWithAuthorSerializer):
    PERSONS_ATTRIBUTE_NAMES = 'reviewer',

    system_data = SystemSerializer(read_only=True, source='system', )
    reviewer_data = StatedPersonSerializer(read_only=True, many=True, source='reviewer', )

    class Meta:
        model = models.IPE
        fields = ('id', 'name', 'service_description',
                  'appliance', 'source_data', 'report_logic',
                  'comment', 'created', 'modified', 'author',
                  'ipe_type', 'system', 'system_data', 'evidence',
                  'date_of_last_change', 'status', 'reviewer',
                  'reviewer_data',
                  )
        read_only_fields = 'created', 'modified',


class IPEDetailSerializer(IPESerializer):
    control_test_ipe_data = ControlTestIPEForIPESerializer(read_only=True, source='control_test_ipe', many=True, )
    evidence_data = FileSerializer(read_only=True, many=True, source='evidence', )

    class Meta:
        model = models.IPE
        fields = IPESerializer.Meta.fields + ('control_test_ipe', 'control_test_ipe_data',
                                              'evidence_data',
                                              )
