from rest_framework import serializers

from .base import BaseSerializer
from intranet.audit.src.core import models


class ParentProcessSerializer(BaseSerializer):
    class Meta:
        model = models.Process
        fields = ('id', 'name', 'process_type',)


class ProcessSerializer(BaseSerializer):
    parent_data = ParentProcessSerializer(read_only=True, source='parent', )

    class Meta:
        model = models.Process
        fields = ('id', 'name', 'process_type', 'parent', 'parent_data', 'actions',)


class ProcessForFilterSerializer(BaseSerializer):
    sub_processes = serializers.SerializerMethodField()

    def get_sub_processes(self, obj):
        if not obj.parent_id:
            ordered_sub_processes = obj.parent_process.all().order_by('name')
            return ProcessForFilterSerializer(
                ordered_sub_processes,
                read_only=True, many=True,
            ).data
        return []

    class Meta:
        model = models.Process
        fields = ('id', 'name', 'sub_processes',)
