from django.conf.urls import url

from . import views


urlpatterns = [
    url(
        r'^export/(?P<obj_class>\w+)/?$',
        views.ExportView.as_view(),
        name='export',
    ),
    url(
        r'^controlplan/run/?$',
        views.RunControlPlanView.as_view(),
        name='controlplan_run',
    ),
    url(
        r'^resources/(?P<obj_class>\w+)/export/?$',
        views.ListExportView.as_view(),
        name='list_export',
    ),

    url(
        r'^resources/(?P<obj_class>\w+)/(?P<pk>[0-9]+)/files/?$',
        views.ExportFilesView.as_view(),
        name='export_files',
    ),
    url(
        r'^resources/(?P<obj_class>\w+)/count/?$',
        views.CountAPIView.as_view(),
        name='count',
    ),
    url(
        r'^resources/(?P<obj_class>\w+)/options/?$',
        views.MetaDataView.as_view(),
        name='metadata',
    ),
    url(
        r'^resources/(?P<obj_class>\w+)/(?P<pk>[0-9]+)/action/?$',
        views.ActionsView.as_view(),
        name='action',
    ),
    url(
        r'^(?P<user_data>\w+)/permissions/?$',
        views.PermissionAPIView.as_view(),
        name='permissions',
    ),

    url(
        r'^resources/controlplan/?$',
        views.ControlPlanListView.as_view(),
        name='controlplan',
    ),
    url(
        r'^resources/controlplan/(?P<pk>[0-9]+)/?$',
        views.ControlPlanDetailView.as_view(),
        name='controlplan_detail',
    ),

    url(
        r'^resources/controltest/?$',
        views.ControlTestListView.as_view(),
        name='controltest',
    ),
    url(
        r'^resources/controltest/(?P<pk>[0-9]+)/?$',
        views.ControlTestDetailView.as_view(),
        name='controltest_detail',
    ),
    url(
        r'^resources/controlstep/?$',
        views.ControlStepListView.as_view(),
        name='controlstep',
    ),
    url(
        r'^resources/controlstep/(?P<pk>[0-9]+)/?$',
        views.ControlStepDetailView.as_view(),
        name='controlstep_detail',
    ),
    url(
        r'^resources/controlstep/(?P<pk>[0-9]+)/(?P<action>[\w-]+)/(?P<related_pk>[0-9]+)/?$',
        views.ControlStepMoveView.as_view(),
        name='controlstep_move',
    ),

    url(
        r'^resources/account/?$',
        views.AccountListView.as_view(),
        name='account',
    ),
    url(
        r'^resources/account/(?P<pk>[0-9]+)/?$',
        views.AccountDetailView.as_view(),
        name='account_detail',
    ),

    url(
        r'^resources/assertion/?$',
        views.AssertionListView.as_view(),
        name='assertion',
    ),
    url(
        r'^resources/assertion/(?P<pk>[0-9]+)/?$',
        views.AssertionDetailView.as_view(),
        name='assertion_detail',
    ),

    url(
        r'^resources/business_unit/?$',
        views.BusinessUnitListView.as_view(),
        name='business_unit',
    ),
    url(
        r'^resources/business_unit/(?P<pk>[0-9]+)/?$',
        views.BusinessUnitDetailView.as_view(),
        name='business_unit_detail',
    ),

    url(
        r'^resources/control/?$',
        views.ControlListView.as_view(),
        name='control',
    ),
    url(
        r'^resources/control/(?P<pk>[0-9]+)/?$',
        views.ControlDetailView.as_view(),
        name='control_detail',
    ),

    url(
        r'^resources/deficiency/?$',
        views.DeficiencyListView.as_view(),
        name='deficiency',
    ),
    url(
        r'^resources/deficiency/(?P<pk>[0-9]+)/?$',
        views.DeficiencyDetailView.as_view(),
        name='deficiency_detail',
    ),
    url(
        r'^resources/deficiencygroup/?$',
        views.DeficiencyGroupListView.as_view(),
        name='deficiencygroup',
    ),
    url(
        r'^resources/deficiencygroup/(?P<pk>[0-9]+)/?$',
        views.DeficiencyGroupDetailView.as_view(),
        name='deficiencygroup_detail',
    ),

    url(
        r'^resources/ipe/?$',
        views.IPEListView.as_view(),
        name='ipe',
    ),
    url(
        r'^resources/ipe/(?P<pk>[0-9]+)/?$',
        views.IPEDetailView.as_view(),
        name='ipe_detail',
    ),

    url(
        r'^resources/legal/?$',
        views.LegalListView.as_view(),
        name='legal',
    ),
    url(
        r'^resources/legal/(?P<pk>[0-9]+)/?$',
        views.LegalDetailView.as_view(),
        name='legal_detail',
    ),

    url(
        r'^resources/risk/?$',
        views.RiskListView.as_view(),
        name='risk',
    ),
    url(
        r'^resources/risk/(?P<pk>[0-9]+)/?$',
        views.RiskDetailView.as_view(),
        name='risk_detail',
    ),

    url(
        r'^resources/service/?$',
        views.ServiceListView.as_view(),
        name='service',
    ),
    url(
        r'^resources/service/(?P<pk>[0-9]+)/?$',
        views.ServiceDetailView.as_view(),
        name='service_detail',
    ),

    url(
        r'^resources/system/?$',
        views.SystemListView.as_view(),
        name='system',
    ),
    url(
        r'^resources/system/(?P<pk>[0-9]+)/?$',
        views.SystemDetailView.as_view(),
        name='system_detail',
    ),

    url(
        r'^resources/process/?$',
        views.ProcessListView.as_view(),
        name='process',
    ),
    url(
        r'^resources/process/(?P<pk>[0-9]+)/?$',
        views.ProcessDetailView.as_view(),
        name='process_detail',
    ),

    url(
        r'^resources/file/?$',
        views.FileListView.as_view(),
        name='file',
    ),
    url(
        r'^resources/file/(?P<pk>[0-9]+)/?$',
        views.FileDetailView.as_view(),
        name='file_detail',
    ),

    url(
        r'^resources/controltestipe/?$',
        views.ControlTestIPEListView.as_view(),
        name='controltestipe',
    ),
    url(
        r'^resources/controltestipe/(?P<pk>[0-9]+)/?$',
        views.ControlTestIPEDetailView.as_view(),
        name='controltestipe_detail',
    ),

    url(
        r'^filter/data(?:/(?P<obj_class>\w+))?/?$',
        views.FilterDataView.as_view(),
        name='filter_data',
    ),
]
