from django.apps import apps
from rest_framework.response import Response
from .view import APIView
from .mixins import FilterMixin, ViewDependentPermissionsMixin
from intranet.audit.src.core.models import BusinessUnit
from intranet.audit.src.files.models import File


DEFAULT_MODEL_APP = 'core'
MODEL_MAP = {
    'business_unit': BusinessUnit,
    'file': File,
}


class CountAPIView(ViewDependentPermissionsMixin, FilterMixin, APIView):

    def get(self, request, obj_class):
        self.model = self.get_model_from_class(obj_class)
        queryset_count = self.get_queryset().values_list('id', flat=True).distinct().count()
        result = {'objects_count': queryset_count}
        return Response(result)

    def get_model_from_class(self, obj_class):
        if obj_class not in MODEL_MAP:
            return apps.get_model(DEFAULT_MODEL_APP, obj_class)
        return MODEL_MAP[obj_class]

    def get_perm_to_check(self, request):
        obj_class = request.parser_context['kwargs']['obj_class']
        model = self.get_model_from_class(obj_class)
        model_name = model.__name__
        model_app = model._meta.app_label
        return '{}.view_{}'.format(model_app, model_name.lower())
