from intranet.audit.src.api_v1.errors import BadRequestError
from intranet.audit.src.api_v1.views import (
    ControlTestDetailView,
    ControlPlanDetailView,
    IPEDetailView,
    DeficiencyDetailView,
    DeficiencyGroupDetailView,
)
from intranet.audit.src.api_v1.views.mixins import RelatedMixin
from intranet.audit.src.api_v1.views.view import ListAPIView
from intranet.audit.src.core import models


VIEW_MAP = {
    'controltest':
        {
            'serializer_class': ControlTestDetailView.serializer_class,
            'model': models.ControlTest,
            'prefetch_related': ControlTestDetailView.prefetch_related,
            'select_related': ControlTestDetailView.select_related,
        },
    'controlplan':
        {
            'serializer_class': ControlPlanDetailView.serializer_class,
            'model': models.ControlPlan,
            'prefetch_related': ControlPlanDetailView.prefetch_related,
            'select_related': ControlPlanDetailView.select_related,
        },
    'ipe':
        {
            'serializer_class': IPEDetailView.serializer_class,
            'model': models.IPE,
            'prefetch_related': IPEDetailView.prefetch_related,
            'select_related': IPEDetailView.select_related,
        },
    'deficiency':
        {
            'serializer_class': DeficiencyDetailView.serializer_class,
            'model': models.Deficiency,
            'prefetch_related': DeficiencyDetailView.prefetch_related,
            'select_related': DeficiencyDetailView.select_related,
        },
    'deficiencygroup':
        {
            'serializer_class': DeficiencyGroupDetailView.serializer_class,
            'model': models.DeficiencyGroup,
            'prefetch_related': DeficiencyGroupDetailView.prefetch_related,
            'select_related': DeficiencyGroupDetailView.select_related,
        },
}


class ListExportView(RelatedMixin, ListAPIView):

    serializer_class = ControlTestDetailView.serializer_class
    model = models.ControlTest
    prefetch_related = ControlTestDetailView.prefetch_related
    select_related = ControlTestDetailView.select_related

    def get(self, request, obj_class):
        view_data = VIEW_MAP.get(obj_class)
        if not view_data:
            raise BadRequestError('Request with not known entity was made')
        for attr, value in view_data.items():
            setattr(self, attr, value)
        return super().get(self, request, obj_class)
