from django.utils.translation import ugettext

from rest_framework.response import Response
from rest_framework.renderers import JSONRenderer
from rest_framework import status

from intranet.audit.src.users.middleware import auth_middleware_exempt
from .view import APIView
from ..errors import BadRequestError
from .listview import (
    ControlPlanListView,
    ControlTestListView,
    AccountListView,
    AssertionListView,
    BusinessUnitListView,
    ControlListView,
    ControlStepListView,
    DeficiencyListView,
    DeficiencyGroupListView,
    IPEListView,
    LegalListView,
    RiskListView,
    ServiceListView,
    SystemListView,
    ProcessListView,
    FileListView,
    ControlTestIPEListView,
)

METADATA_MAP = {
    'controlplan': ControlPlanListView,
    'controltest': ControlTestListView,
    'account': AccountListView,
    'assertion': AssertionListView,
    'business_unit': BusinessUnitListView,
    'control': ControlListView,
    'controlstep': ControlStepListView,
    'deficiency': DeficiencyListView,
    'deficiencygroup': DeficiencyGroupListView,
    'ipe': IPEListView,
    'legal': LegalListView,
    'risk': RiskListView,
    'service': ServiceListView,
    'system': SystemListView,
    'process': ProcessListView,
    'file': FileListView,
    'controltestipe': ControlTestIPEListView,
}


@auth_middleware_exempt()
class MetaDataView(APIView):
    authentication_classes = tuple()
    renderer_classes = (JSONRenderer, )

    def get(self, request, obj_class):
        options_view = METADATA_MAP.get(obj_class)
        if not options_view:
            # Translators: Используется в ответе апи в случае если был
            # сделан запрос с неправильным классом
            raise BadRequestError(ugettext('Request with wrong obj_class was made: {}'.format(obj_class)))

        options_instance = options_view()
        options_instance.request = request
        options_instance.format_kwarg = options_instance.get_format_suffix()
        data = options_instance.metadata_class().determine_metadata(request, options_instance)
        return Response(data, status=status.HTTP_200_OK)
