from rest_framework.metadata import SimpleMetadata

MULTI_CHOICE_DATA = {
        'ManyRelatedField': True,
        'PrimaryKeyRelatedField': False,
    }

SUGGEST_DATA = {
        'owner': 'stated_person',
        'tester': 'stated_person',
        'responsible': 'stated_person',
        'service_description': 'abc_service',
        'process': 'process',
        'account': 'account',
        'legal': 'legal',
        'assertion': 'assertion',
        'system': 'system',
        'service': 'service',
        'risk': 'risk',
        'control': 'control',
        'control_plan': 'control_plan',
        'control_step': 'control_step',
        'ipe': 'ipe',
        'business_unit': 'business_unit',
        'control_test': 'control_test',
        'deficiency': 'deficiency',
        'attach': 'file',
        'evidence': 'file',
        'deficiencies': 'deficiency',
}

MODEL_LABEL_DATA = {
    'risk': {'ru': 'Риск', 'en': 'Risk'}
}

MODEL_DEFAULT_LABEL_DATA = {
    'legal': 'Legal Entity',
}


class AuditMetadata(SimpleMetadata):
    """
    Добавляет дополнительную информацию в OPTIONS
    ответы ручек
    """

    def get_field_info(self, field):
        field_class = field.__class__.__name__
        field_info = super().get_field_info(field)
        if field_info['type'] == 'field' and field_info['read_only'] is False:
            field_info['multi_choice'] = MULTI_CHOICE_DATA[field_class]
        suggest = SUGGEST_DATA.get(field.field_name)

        if suggest is not None:
            field_info['suggest'] = suggest
        label_info = field_info.get('label')
        if label_info:
            field_info['label'] = self.get_label(field, label_info)
        return field_info

    def determine_actions(self, request, view):
        serializer = view.get_serializer()
        actions = {
            'META': self.get_serializer_info(serializer)
        }
        return actions

    def get_label(self, field, label_default_info):
        label_info = MODEL_LABEL_DATA.get(field.field_name, {})
        label_info['default'] = self.get_default_label(field, label_default_info)
        return label_info

    def get_default_label(self, field, label_default_info):
        return MODEL_DEFAULT_LABEL_DATA.get(field.field_name) or label_default_info

