from .base import AuditMetadata


ADDITIONAL_INFO_MAP = {
    'assertion': {'choices_endpoint': '/api/v1/resources/assertion',
                  'type': 'choice',
                  }
}


class ControlPlanMetadata(AuditMetadata):
    """
    Добавляем в ответ ручек ControlPlan по Options
    запросу информацию об assertions для отрисовки списка
    """

    def get_field_info(self, field):
        base_info = super().get_field_info(field)
        additional_info = ADDITIONAL_INFO_MAP.get(field.field_name)
        if additional_info:
            base_info.update(additional_info)

        return base_info
