from rest_framework.response import Response
from .view import APIView
from ..errors import BadRequestError, AccessError
from rest_framework.renderers import JSONRenderer
from intranet.audit.src.users.models import User
from django.utils.translation import ugettext


class PermissionAPIView(APIView):
    renderer_classes = JSONRenderer,
    perm = 'users.view_permissions'

    def get(self, request, user_data):
        if user_data == 'me':
            permissions = self.request.user.get_all_permissions()
        else:
            if self.request.user.uid != user_data and not self.request.user.has_perm(self.perm):
                raise AccessError()
            try:
                user = User.objects.get(uid=user_data)
            except User.DoesNotExist:
                # Translators: Выводится в ответе апи если был передан
                # uid, пользователя с которым не существует
                raise BadRequestError(ugettext('No user with such uid exists: {}'.format(user_data)))
            permissions = user.get_all_permissions()
        result = {permission: True for permission in permissions}
        return Response(result)
