from django.http import HttpResponse
from django.utils.translation import ugettext

from rest_framework.response import Response

from intranet.audit.src.users.middleware import auth_middleware_exempt
from intranet.audit.src.api_v1.views.view import APIView


@auth_middleware_exempt()
def ping(request):
    return HttpResponse()


@auth_middleware_exempt()
class NoLoginView(APIView):
    def get(self, request):
        data = {'message': (ugettext('You don\'t have access to admin '
                            'site view, please contact support'))}
        return Response(data=data)
