from .. import models


def copy_control_steps(*control_tests, author, new_control_tests):
    """
    Создает копии шагов привязанных к переданным control_test
    и прикрепляет их к новым control_test
    """

    new_steps = list()

    for control_test in control_tests:
        for step in control_test.controlstep_set.all():
            new_steps.append(models.ControlStep(
                step=step.step,
                author=author,
                control_test=new_control_tests[control_test.control_plan_id]
            ))

    return models.ControlStep.objects.bulk_create(new_steps)
