import logging

from django.conf import settings

from ids.registry import registry
from ids.exceptions import IDSException

logger = logging.getLogger(__name__)


def get_abc_services(query):
    abc_repository = registry.get_repository(
        service='abc',
        resource_type='service',
        user_agent='audit',
        oauth_token=settings.ROBOT_OAUTH_TOKEN,
    )
    query = settings.ABC_REGEX.format(query)
    try:
        lookup = {
            '_query': query,
            '_fields': settings.ABC_FIELDS,
            '_limit': '50',
        }
        services = abc_repository.get(lookup=lookup)
    except IDSException:
        logger.exception('Got exception from abc-api with query: "%s"', query)
        return []
    return prepare_services(*services)


def prepare_services(*services):
    return ['{} ({})'.format(service['name']['ru'],
                            settings.ABC_SERVICE_URL.format(service['slug']))
            for service in services]
