import itertools

from intranet.audit.src.core.dao import controltest


def get_last_controltests_by_plans(*control_plans):
    """
    Возвращает последний по дате создания control_test
    для каждого из переданных control_plan, если такой
    существует

    заменить на, если/когда будет решено
    https://github.com/jazzband/django-model-utils/issues/289

    from django.db.models import Max, F
    last_controltests = models.ControlTest.objects.filter(
        control_plan__in=control_plans).annotate(
        max_date=Max('control_plan__controltest__created')).filter(
        created=F('max_date'))
    """
    last_controltests = list()
    control_tests = controltest.get_controltests_by_plans(*control_plans).order_by('control_plan_id')
    for control_plan_id, control_tests in itertools.groupby(control_tests,
                                                            lambda obj: obj.control_plan_id):
        last_controltests.append(sorted(control_tests,
                                        key=lambda control_test: control_test.created,
                                        reverse=True,
                                        )[0])
    return last_controltests
