from intranet.audit.src.users.logic.user import already_created


def prepare_form_data(attrs_names, cleaned_form,):
    """
    Оставляет в форме только те uid,
    объекты относящиеся к которым уже
    были ранее созданы
    """
    for attr_name in attrs_names:
        cleaned_form[attr_name] = [uid for uid in cleaned_form.get(attr_name, []) if already_created(uid)]


def update_form_data(ids_data, stated_persons, cleaned_form, ):
    """
    Обновляет данные формы, добавляя
    id новых stated_persons
    к данным нужных полей
    """
    for uid, form_attrs in ids_data.items():
        stated_person_obj = stated_persons[uid]
        for form_attr in form_attrs:
            cleaned_form[form_attr].append(stated_person_obj.id)

