from django.conf import settings

from tvmauth import BlackboxTvmId as BlackboxClientId
from tvm2 import TVM2


def get_tvm2_client():
    return TVM2(
        client_id=settings.TVM2_CLIENT_ID,
        secret=settings.TVM2_SECRET,
        blackbox_client=BlackboxClientId.ProdYateam,
        destinations=settings.TVM2_DESTINATIONS,
        api_url=settings.TVM2_API_URL,
    )


def get_service_ticket(client_id):
    client_id = str(client_id)
    return get_tvm2_client().get_service_tickets(client_id).get(client_id)
