# -*- coding: utf-8 -*-
# Generated by Django 1.11.1 on 2020-03-11 11:59
from __future__ import unicode_literals

from django.conf import settings
from django.db import migrations, models
import django.db.models.deletion
import django.utils.timezone
import model_utils.fields


class Migration(migrations.Migration):

    initial = True

    dependencies = [
        migrations.swappable_dependency(settings.AUTH_USER_MODEL),
        ('users', '0003_auto_20180315_1000'),
        ('files', '0001_initial'),
    ]

    operations = [
        migrations.CreateModel(
            name='Account',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created', model_utils.fields.AutoCreatedField(default=django.utils.timezone.now, editable=False, verbose_name='created')),
                ('modified', model_utils.fields.AutoLastModifiedField(default=django.utils.timezone.now, editable=False, verbose_name='modified')),
                ('is_removed', models.BooleanField(default=False)),
                ('name', models.CharField(max_length=1000, unique=True)),
                ('author', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to=settings.AUTH_USER_MODEL)),
                ('parent', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, related_name='parent_account', to='core.Account')),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='Assertion',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created', model_utils.fields.AutoCreatedField(default=django.utils.timezone.now, editable=False, verbose_name='created')),
                ('modified', model_utils.fields.AutoLastModifiedField(default=django.utils.timezone.now, editable=False, verbose_name='modified')),
                ('is_removed', models.BooleanField(default=False)),
                ('name', models.CharField(max_length=1000, unique=True)),
                ('author', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to=settings.AUTH_USER_MODEL)),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='BusinessUnit',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created', model_utils.fields.AutoCreatedField(default=django.utils.timezone.now, editable=False, verbose_name='created')),
                ('modified', model_utils.fields.AutoLastModifiedField(default=django.utils.timezone.now, editable=False, verbose_name='modified')),
                ('is_removed', models.BooleanField(default=False)),
                ('name', models.CharField(max_length=1000, unique=True)),
                ('author', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to=settings.AUTH_USER_MODEL)),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='Control',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created', model_utils.fields.AutoCreatedField(default=django.utils.timezone.now, editable=False, verbose_name='created')),
                ('modified', model_utils.fields.AutoLastModifiedField(default=django.utils.timezone.now, editable=False, verbose_name='modified')),
                ('is_removed', models.BooleanField(default=False)),
                ('name', models.CharField(max_length=1000)),
                ('number', models.CharField(help_text='Номер контрольной процедуры', max_length=100, unique=True)),
                ('author', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to=settings.AUTH_USER_MODEL)),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='ControlPlan',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created', model_utils.fields.AutoCreatedField(default=django.utils.timezone.now, editable=False, verbose_name='created')),
                ('modified', model_utils.fields.AutoLastModifiedField(default=django.utils.timezone.now, editable=False, verbose_name='modified')),
                ('is_removed', models.BooleanField(default=False)),
                ('status', models.CharField(choices=[('draft', 'Draft'), ('review', 'Review'), ('active', 'Active'), ('archived', 'Archived'), ('deleted', 'Deleted')], default='draft', max_length=25)),
                ('reliance', models.BooleanField(default=False)),
                ('key_control', models.BooleanField(default=True)),
                ('to_test', models.BooleanField(default=True)),
                ('comment', models.TextField(blank=True, null=True)),
                ('method', models.CharField(choices=[('manual', 'Ручной'), ('auto', 'Автоматический'), ('it_dependent', 'Комбинированный')], max_length=25)),
                ('frequency', models.CharField(choices=[('yearly', 'Eжегодно'), ('half_yearly', 'Раз в полгода'), ('quarterly', 'Ежеквартально'), ('monthly', 'Ежемесячно'), ('weekly', 'Еженедельно'), ('daily', 'Ежедневно'), ('many_times_per_day', 'Несколько раз в день'), ('adhoc', 'Ad-Hoc')], help_text='Частота выполнения контроля', max_length=25)),
                ('control_type', models.CharField(choices=[('warning', 'Предупреждающая'), ('revealing', 'Выявляющая')], help_text='Тип контроля', max_length=25)),
                ('antifraud', models.BooleanField(default=False, help_text='Противодействие мошенничеству')),
                ('evidence', models.TextField(blank=True, help_text='Доказательство выполнения контроля', null=True)),
                ('regulation', models.TextField(blank=True, help_text='Наименование внутреннего нормативного документа', null=True)),
                ('description', models.TextField(blank=True, help_text='Полное описание контроля в контексте плана', null=True, verbose_name='full description')),
                ('test_period_started', models.DateField(blank=True, null=True, verbose_name='Plan period started')),
                ('test_period_finished', models.DateField(blank=True, null=True, verbose_name='Plan period finished')),
                ('account', models.ManyToManyField(blank=True, to='core.Account')),
                ('assertion', models.ManyToManyField(blank=True, to='core.Assertion')),
                ('author', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to=settings.AUTH_USER_MODEL)),
                ('business_unit', models.ManyToManyField(blank=True, to='core.BusinessUnit')),
                ('control', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='core.Control')),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='ControlStep',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created', model_utils.fields.AutoCreatedField(default=django.utils.timezone.now, editable=False, verbose_name='created')),
                ('modified', model_utils.fields.AutoLastModifiedField(default=django.utils.timezone.now, editable=False, verbose_name='modified')),
                ('is_removed', models.BooleanField(default=False)),
                ('step', models.TextField(help_text='Описание шага')),
                ('comment', models.TextField(blank=True, help_text='Комментарий', null=True)),
                ('result', models.CharField(blank=True, choices=[('ok', 'OK'), ('not_ok', 'NOT OK')], help_text='Результат', max_length=10, null=True)),
                ('author', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to=settings.AUTH_USER_MODEL)),
            ],
        ),
        migrations.CreateModel(
            name='ControlTest',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created', model_utils.fields.AutoCreatedField(default=django.utils.timezone.now, editable=False, verbose_name='created')),
                ('modified', model_utils.fields.AutoLastModifiedField(default=django.utils.timezone.now, editable=False, verbose_name='modified')),
                ('is_removed', models.BooleanField(default=False)),
                ('status', models.CharField(choices=[('draft', 'Draft'), ('review', 'Review'), ('active', 'Tested'), ('archived', 'Archived'), ('deleted', 'Deleted')], default='draft', max_length=25)),
                ('test_period_started', models.DateField(blank=True, null=True)),
                ('test_period_finished', models.DateField(blank=True, null=True)),
                ('testing_date', models.DateField(blank=True, null=True)),
                ('sampling', models.TextField(blank=True, null=True)),
                ('evidence_comments', models.TextField(blank=True, null=True)),
                ('design_efficiency', models.CharField(blank=True, choices=[('effective', 'Effective'), ('ineffective', 'Ineffective')], max_length=50, null=True)),
                ('operational_efficiency', models.CharField(blank=True, choices=[('effective', 'Effective'), ('ineffective', 'Ineffective'), ('n_a', 'N/A')], max_length=50, null=True)),
                ('comment', models.TextField(blank=True, null=True)),
                ('author', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to=settings.AUTH_USER_MODEL)),
                ('control_plan', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='core.ControlPlan')),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='ControlTestIPE',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created', model_utils.fields.AutoCreatedField(default=django.utils.timezone.now, editable=False, verbose_name='created')),
                ('modified', model_utils.fields.AutoLastModifiedField(default=django.utils.timezone.now, editable=False, verbose_name='modified')),
                ('is_removed', models.BooleanField(default=False)),
                ('status', models.CharField(blank=True, choices=[('ok', 'OK'), ('not_ok', 'Not OK')], max_length=25, null=True)),
                ('report_parameters', models.TextField(blank=True, null=True)),
                ('attach', models.ManyToManyField(blank=True, to='files.File')),
                ('author', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to=settings.AUTH_USER_MODEL)),
                ('control_test', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='control_test_ipe', to='core.ControlTest')),
            ],
        ),
        migrations.CreateModel(
            name='Deficiency',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created', model_utils.fields.AutoCreatedField(default=django.utils.timezone.now, editable=False, verbose_name='created')),
                ('modified', model_utils.fields.AutoLastModifiedField(default=django.utils.timezone.now, editable=False, verbose_name='modified')),
                ('is_removed', models.BooleanField(default=False)),
                ('full_description', models.TextField(blank=True, help_text='Подробное описание', null=True)),
                ('potential_impact', models.CharField(blank=True, choices=[('low', 'low'), ('medium', 'medium'), ('high', 'high')], help_text='Потенциальная величина искажения', max_length=10, null=True)),
                ('misstatement_probability', models.CharField(blank=True, choices=[('low', 'low'), ('medium', 'medium'), ('high', 'high')], help_text='Вероятность искажения', max_length=10, null=True)),
                ('mitigating_factors', models.TextField(blank=True, help_text='Факторы, снижающие риск искажения', null=True)),
                ('significance_evaluation', models.CharField(blank=True, choices=[('low', 'low'), ('medium', 'medium'), ('high', 'high')], help_text='Оценка значимости недостатка', max_length=10, null=True)),
                ('comment', models.TextField(blank=True, null=True)),
                ('estimate_closing_date', models.DateField(blank=True, help_text='Предполагаемая дата закрытия', null=True)),
                ('short_description', models.TextField(help_text='Краткое описание')),
                ('state', models.CharField(choices=[('open', 'open'), ('fixed', 'fixed'), ('deleted', 'deleted')], default='open', max_length=10)),
                ('ticket_key', models.TextField(blank=True, null=True, verbose_name='startrek ticket')),
                ('author', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to=settings.AUTH_USER_MODEL)),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='DeficiencyGroup',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created', model_utils.fields.AutoCreatedField(default=django.utils.timezone.now, editable=False, verbose_name='created')),
                ('modified', model_utils.fields.AutoLastModifiedField(default=django.utils.timezone.now, editable=False, verbose_name='modified')),
                ('is_removed', models.BooleanField(default=False)),
                ('full_description', models.TextField(blank=True, help_text='Подробное описание', null=True)),
                ('potential_impact', models.CharField(blank=True, choices=[('low', 'low'), ('medium', 'medium'), ('high', 'high')], help_text='Потенциальная величина искажения', max_length=10, null=True)),
                ('misstatement_probability', models.CharField(blank=True, choices=[('low', 'low'), ('medium', 'medium'), ('high', 'high')], help_text='Вероятность искажения', max_length=10, null=True)),
                ('mitigating_factors', models.TextField(blank=True, help_text='Факторы, снижающие риск искажения', null=True)),
                ('significance_evaluation', models.CharField(blank=True, choices=[('low', 'low'), ('medium', 'medium'), ('high', 'high')], help_text='Оценка значимости недостатка', max_length=10, null=True)),
                ('comment', models.TextField(blank=True, null=True)),
                ('estimate_closing_date', models.DateField(blank=True, help_text='Предполагаемая дата закрытия', null=True)),
                ('state', models.CharField(choices=[('open', 'open'), ('fixed', 'fixed'), ('incorrect', 'incorrect')], default='open', max_length=16)),
                ('author', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to=settings.AUTH_USER_MODEL)),
                ('deficiencies', models.ManyToManyField(blank=True, related_name='groups', to='core.Deficiency')),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='IPE',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created', model_utils.fields.AutoCreatedField(default=django.utils.timezone.now, editable=False, verbose_name='created')),
                ('modified', model_utils.fields.AutoLastModifiedField(default=django.utils.timezone.now, editable=False, verbose_name='modified')),
                ('is_removed', models.BooleanField(default=False)),
                ('name', models.CharField(max_length=1000)),
                ('status', models.CharField(choices=[('in_progress', 'InProgress'), ('review', 'Review'), ('archived', 'Archived'), ('deleted', 'Deleted')], default='in_progress', max_length=25)),
                ('service_description', models.CharField(blank=True, help_text='Сервис ABC', max_length=500, null=True)),
                ('appliance', models.CharField(blank=True, choices=[('control', 'control'), ('testing', 'testing'), ('control_testing', 'control/testing')], max_length=25, null=True)),
                ('source_data', models.TextField(blank=True, null=True)),
                ('report_logic', models.TextField(blank=True, null=True)),
                ('comment', models.TextField(blank=True, null=True)),
                ('ipe_type', models.CharField(blank=True, choices=[('standart', 'Standart'), ('custom', 'Custom')], max_length=25, null=True, verbose_name='Type')),
                ('date_of_last_change', models.DateField(blank=True, null=True, verbose_name='Дата последнего изменения отчета')),
                ('author', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to=settings.AUTH_USER_MODEL)),
                ('evidence', models.ManyToManyField(blank=True, to='files.File', verbose_name='Attach')),
                ('reviewer', models.ManyToManyField(blank=True, to='users.StatedPerson')),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='Legal',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created', model_utils.fields.AutoCreatedField(default=django.utils.timezone.now, editable=False, verbose_name='created')),
                ('modified', model_utils.fields.AutoLastModifiedField(default=django.utils.timezone.now, editable=False, verbose_name='modified')),
                ('is_removed', models.BooleanField(default=False)),
                ('name', models.CharField(max_length=1000, unique=True)),
                ('author', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to=settings.AUTH_USER_MODEL)),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='Process',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created', model_utils.fields.AutoCreatedField(default=django.utils.timezone.now, editable=False, verbose_name='created')),
                ('modified', model_utils.fields.AutoLastModifiedField(default=django.utils.timezone.now, editable=False, verbose_name='modified')),
                ('is_removed', models.BooleanField(default=False)),
                ('name', models.CharField(max_length=1000, unique=True)),
                ('process_type', models.CharField(choices=[('root', 'корневой процесс'), ('subprocess', 'подпроцесс')], max_length=50)),
                ('author', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to=settings.AUTH_USER_MODEL)),
                ('parent', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, related_name='parent_process', to='core.Process')),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='Risk',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created', model_utils.fields.AutoCreatedField(default=django.utils.timezone.now, editable=False, verbose_name='created')),
                ('modified', model_utils.fields.AutoLastModifiedField(default=django.utils.timezone.now, editable=False, verbose_name='modified')),
                ('is_removed', models.BooleanField(default=False)),
                ('name', models.CharField(max_length=1000)),
                ('number', models.CharField(help_text='Номер риска', max_length=100, unique=True)),
                ('author', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to=settings.AUTH_USER_MODEL)),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='Service',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created', model_utils.fields.AutoCreatedField(default=django.utils.timezone.now, editable=False, verbose_name='created')),
                ('modified', model_utils.fields.AutoLastModifiedField(default=django.utils.timezone.now, editable=False, verbose_name='modified')),
                ('is_removed', models.BooleanField(default=False)),
                ('name', models.CharField(max_length=1000, unique=True)),
                ('service_description', models.CharField(blank=True, help_text='Сервис ABC', max_length=500, null=True)),
                ('author', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to=settings.AUTH_USER_MODEL)),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='System',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created', model_utils.fields.AutoCreatedField(default=django.utils.timezone.now, editable=False, verbose_name='created')),
                ('modified', model_utils.fields.AutoLastModifiedField(default=django.utils.timezone.now, editable=False, verbose_name='modified')),
                ('is_removed', models.BooleanField(default=False)),
                ('name', models.CharField(max_length=1000, unique=True)),
                ('service_description', models.CharField(blank=True, help_text='Сервис ABC', max_length=500, null=True)),
                ('author', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to=settings.AUTH_USER_MODEL)),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.AddField(
            model_name='ipe',
            name='system',
            field=models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, to='core.System'),
        ),
        migrations.AddField(
            model_name='controltestipe',
            name='ipe',
            field=models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='control_test_ipe', to='core.IPE'),
        ),
        migrations.AddField(
            model_name='controltest',
            name='deficiency',
            field=models.ManyToManyField(blank=True, related_name='control_test', to='core.Deficiency'),
        ),
        migrations.AddField(
            model_name='controltest',
            name='evidence',
            field=models.ManyToManyField(blank=True, to='files.File'),
        ),
        migrations.AddField(
            model_name='controltest',
            name='reviewer',
            field=models.ManyToManyField(blank=True, to='users.StatedPerson'),
        ),
        migrations.AddField(
            model_name='controltest',
            name='tester',
            field=models.ManyToManyField(blank=True, related_name='tester', to='users.StatedPerson'),
        ),
        migrations.AddField(
            model_name='controlstep',
            name='control_test',
            field=models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, to='core.ControlTest'),
        ),
        migrations.AddField(
            model_name='controlstep',
            name='file',
            field=models.ManyToManyField(blank=True, to='files.File'),
        ),
        migrations.AddField(
            model_name='controlplan',
            name='legal',
            field=models.ManyToManyField(blank=True, to='core.Legal'),
        ),
        migrations.AddField(
            model_name='controlplan',
            name='owner',
            field=models.ManyToManyField(blank=True, related_name='control_owner', to='users.StatedPerson'),
        ),
        migrations.AddField(
            model_name='controlplan',
            name='process',
            field=models.ManyToManyField(to='core.Process'),
        ),
        migrations.AddField(
            model_name='controlplan',
            name='reviewer',
            field=models.ManyToManyField(blank=True, to='users.StatedPerson'),
        ),
        migrations.AddField(
            model_name='controlplan',
            name='risk',
            field=models.ManyToManyField(to='core.Risk'),
        ),
        migrations.AddField(
            model_name='controlplan',
            name='service',
            field=models.ManyToManyField(blank=True, to='core.Service'),
        ),
        migrations.AddField(
            model_name='controlplan',
            name='system',
            field=models.ManyToManyField(blank=True, to='core.System'),
        ),
        migrations.AlterOrderWithRespectTo(
            name='controltestipe',
            order_with_respect_to='control_test',
        ),
        migrations.AlterOrderWithRespectTo(
            name='controlstep',
            order_with_respect_to='control_test',
        ),
    ]
