from django.db import models
from django.utils.translation import ugettext
from model_utils import Choices


class StatusMixin(models.Model):
    STATUSES = Choices(
        ('in_progress', ugettext('InProgress')),
        ('review', ugettext('Review')),
        ('archived', ugettext('Archived')),
        ('deleted', ugettext('Deleted')),
    )
    DEFAULT_STATUS = STATUSES.in_progress
    status = models.CharField(max_length=25, choices=STATUSES, default=DEFAULT_STATUS)

    class Meta:
        abstract = True


class ReviewerMixin(models.Model):
    reviewer = models.ManyToManyField('users.StatedPerson', blank=True, )

    class Meta:
        abstract = True
