from django.contrib import admin
from django import forms

from intranet.audit.src.core.admin import NamedObjectAdmin

from . import models


class FileAdminWidget(forms.ClearableFileInput):

    def render(self, name, value, attrs=None, renderer=None):
        if value:
            value.name = None
        return super().render(name, value,
                              attrs=None, renderer=None)


class FileAdminForm(forms.ModelForm):

    class Meta:
        model = models.File
        fields = '__all__'
        widgets = {
            'file': FileAdminWidget,
        }


class FileAdmin(NamedObjectAdmin):
    base_fields = 'name', 'file_link',
    fields = ('name', 'file_link', 'file', 'author', 'created', 'modified', )
    form = FileAdminForm
    readonly_fields = ('name', 'file_link', ) + NamedObjectAdmin.readonly_fields

    def get_fields(self, request, obj=None):
        if not request.user.has_perm('files.change_file'):
            return self.base_fields
        return super().get_fields(request, obj)


admin.site.register(models.File, FileAdmin)
