from django.core import urlresolvers

from ajax_select import register

from intranet.audit.src.core.lookups import NameLookup
from . import models


@register('file')
class FileLookup(NameLookup):
    model = models.File

    def format_item_display(self, item):
        link = urlresolvers.reverse("admin:files_{}_change".format(item.__class__.__name__.lower()),
                                    args=[item.id])
        return u'<a href="%s">%s</a>' % (link, item)
