import requests
import urllib.parse
import logging
import mimetypes

from django.conf import settings
from django.http import StreamingHttpResponse, HttpResponse
from django.views import View
from django.shortcuts import get_object_or_404

from .models import File

logger = logging.getLogger(__name__)

_FILE_DOWNLOAD_CHUNK_SIZE = 50 * (1 << 20)  # 50Mb


class GetFileView(View):
    def get(self, request, pk):
        """
        Почти весь код ниже взят из работающего
        на проде метода в jing
        https://github.yandex-team.ru/tools/jing/blob/master/src/jing_web/portal/views/base.py#L83
        """
        obj = get_object_or_404(File, pk=pk)
        object_url = obj.file.url

        # пытаемся выяснить корректный content-type ответа
        url_path = urllib.parse.urlsplit(object_url).path
        mime_type, encoding = mimetypes.guess_type(url_path)
        if not mime_type:
            content_type = u'application/octet-stream;'
        elif encoding:
            content_type = u"; charset=".join([mime_type, encoding])
        else:
            content_type = mime_type

        user_agent = request.META['HTTP_USER_AGENT']

        try:
            headers = {}
            is_range_enabled = (
                any(ua in user_agent for ua in ('YaBrowser', 'Safari'))
                and request.META.get('HTTP_RANGE', '')
            )
            if 'video' in content_type and is_range_enabled:
                headers['range'] = request.META.get('HTTP_RANGE', '').strip()

            mds_response = requests.get(
                url=object_url,
                headers=headers,
                stream=True,
                timeout=5,
                verify=settings.AWS_S3_VERIFY,
            )
        except requests.RequestException as exc:
            logger.error('Got error from storage "%s", url: "%s"', exc, url_path)
            message = 'Got error from storage'
            return HttpResponse(message, status=503)

        response = StreamingHttpResponse(
            mds_response.iter_content(chunk_size=_FILE_DOWNLOAD_CHUNK_SIZE),
            content_type=content_type
        )

        if mds_response.headers.get('Content-Encoding') == 'gzip':
            del mds_response.headers['Content-Encoding']
        if mds_response.headers.get('Transfer-Encoding') == 'chunked':
            del mds_response.headers['Transfer-Encoding']
        if 'Content-Type' in mds_response.headers:
            del mds_response.headers['Content-Type']

        for header_name, header_value in mds_response.headers.items():
            response[header_name] = header_value

        #  так надо для я.браузера иначе не хочет играть некоторые видео
        if response.get('content-range'):
            response.status_code = '206'

        name = urllib.parse.quote(obj.name.encode('utf-8'))
        response['Content-Disposition'] = "attachment; filename*=utf-8''{}".format(name)
        return response
