import json

from constance import config
from django.views.generic import TemplateView
from django.http import HttpResponseRedirect
from django.conf import settings
from django_yauth.util import get_passport_url, get_yauth_type
from django_tools_log_context import request_context, request_profiler

from intranet.audit.src.users.middleware import auth_middleware_exempt


@auth_middleware_exempt(need_yauser=True)
class BaseTemplateView(TemplateView):
    def dispatch(self, request, *args, **kwargs):
        with request_context(request, endpoint=self):
            with request_profiler(request, threshold=settings.THRESHOLD):
                if request.yauser and request.yauser.is_authenticated():
                    return super().dispatch(request, *args, **kwargs)
                passport_url = get_passport_url('create', get_yauth_type(request), request=request, retpath=True)
                return HttpResponseRedirect(passport_url)


class IndexView(BaseTemplateView):

    template_name = 'index.html'

    def get_context_data(self, **kwargs):
        context = super(IndexView, self).get_context_data(**kwargs)
        context['frontend_packages'] = json.loads(config.FRONTEND_PACKAGES)
        context['frontend_version'] = config.FRONTEND_VERSION
        return context
