# coding: utf-8

from django.conf.urls import url, include
from django.conf.urls.static import static
from django.conf import settings
from django.contrib import admin
from ajax_select import urls as ajax_select_urls

from .frontend import views as frontend_views
from .common_views import ping, NoLoginView


urlpatterns = [
    url(r'^$', frontend_views.IndexView.as_view()),
    url(r'^adminlogin/', NoLoginView.as_view()),
    url(r'^admin/', include(admin.site.urls)),
    url(r'^api/v1/files/', include('intranet.audit.src.files.urls', namespace='files')),
    url(r'^api/v1/', include('intranet.audit.src.api_v1.urls', namespace='api_v1')),
    url(r'^api/v1/suggest/', include(ajax_select_urls)),
    url(r'^ping/?', ping),
    url(r'^advanced_filters/', include('advanced_filters.urls')),
    url(r'^(?!api)(?:[\w-]+\/?)+$', frontend_views.IndexView.as_view()),
]

# в 'development' используем встроенную в джангу вьюху для раздачи
# остальных окружениях используем WhiteNoiseMiddleware middleware
urlpatterns += static(
    settings.STATIC_URL,
    document_root=settings.STATIC_ROOT,
)
