import logging

from django.conf import settings

from ids.registry import registry
from ids.exceptions import IDSException

from intranet.audit.src.core.logic.request import get_service_ticket

logger = logging.getLogger(__name__)


def get_staff_persons(query):
    staff_repository = registry.get_repository(
        service='staff',
        resource_type='person',
        user_agent='audit',
        service_ticket=get_service_ticket(settings.TVM2_STAFF_API_CLIENT_ID),
        timeout=5,
    )
    try:
        lookup = {
            '_query': query,
            '_fields': settings.STAFF_FIELDS,
            '_limit': '50',
        }
        persons = staff_repository.get(lookup=lookup)
    except IDSException:
        logger.exception('Got exception from staff-api with query: "%s"', query)
        persons = []

    return persons


def suggest_persons(query, request):
    isearch_repository = registry.get_repository(
        service='intrasearch',
        resource_type='suggest',
        user_agent='audit',
        user_ticket=request.yauser.raw_user_ticket,
        service_ticket=get_service_ticket(settings.TVM2_ISEARCH_CLIENT_ID),
        timeout=1,
    )
    try:
        lookup = {
            'text': query,
            'version': 2,
            'layers': 'people',
            'people.per_page': 10,
        }
        result = isearch_repository.getiter(lookup=lookup)
        persons = result['people']['result']
    except IDSException:
        logger.exception('Got exception from suggest with query: "%s"', query)
        persons = []

    return persons
