import itertools

from ajax_select import register, LookupChannel

from . import models
from .dao.user import get_group_stated_data
from .logic.staff_person import suggest_persons


@register('stated_person')
class StatedPersonLookup(LookupChannel):
    model = models.StatedPerson

    def get_query(self, q, request):
        group_data = get_group_stated_data(q)
        search_result = []
        for person in suggest_persons(query=q, request=request):
            search_result.append(models.StatedPerson(
                id=person['uid'],
                uid=person['uid'],
                first_name=person['name']['first'],
                last_name=person['name']['last'],
                login=person['login'],
                department=person['department_name'],
                position=person['position'],
            ))
        return itertools.chain(group_data, search_result)

    def can_add(self, user, model):
        return False

    def format_item_display(self, obj):
        return obj.format_item_display
