PY3_LIBRARY(audit)

OWNER(g:tools-audit)

PEERDIR(
    contrib/python/aiohttp
    contrib/python/boto3
    contrib/python/django/django-1.11
    contrib/python/django-admin-view-permission
    contrib/python/django-advanced-filters
    contrib/python/django-ajax-selects
    contrib/python/django-constance/py2
    contrib/python/django-environ
    contrib/python/django-extensions/py2
    contrib/python/django-import-export/py2
    contrib/python/django-model-utils/py2
    contrib/python/django-modeladmin-reorder
    contrib/python/django-picklefield
    contrib/python/django-rest-multiple-models
    contrib/python/django-storages
    contrib/python/django-replicated
    contrib/python/django-cors-middleware
    contrib/python/djangorestframework
    contrib/python/ipython
    contrib/python/multidict
    contrib/python/openpyxl
    contrib/python/Pillow
    contrib/python/psycopg2
    contrib/python/pytz
    contrib/python/requests
    contrib/python/tablib
    contrib/python/uwsgi
    contrib/python/whitenoise
    contrib/python/zero-downtime-migrations

    library/python/blackbox
    library/python/datasources-config-wrapper
    library/python/django
    library/python/django_pgaas
    library/python/django_tools_log_context
    library/python/granular_settings
    library/python/ids
    library/python/python-django-yauth
    library/python/tvm2
    library/python/ylog
)

PY_SRCS(
    __init__.py
    common_views.py
    manage.py
    settings.py
    makemigrations_settings.py
    urls.py
)

RESOURCE_FILES(
    PREFIX intranet/audit/src/

    settings/001-datasources.conf
    settings/002-datasources.conf.production
    settings/002-datasources.conf.testing
    settings/010-django.conf
    settings/010-django.conf.development
    settings/020-logging.conf
    settings/025-auth.conf
    settings/026-yauth.conf
    settings/026-yauth.conf.production
    settings/030-apps.conf
    settings/050-databases.conf
    settings/050-databases.conf.development
    settings/050-databases.conf.development.unittest
    settings/060-middleware.conf
    settings/061-middleware.conf.development
    settings/061-middleware.conf.development.unittest
    settings/070-admin_order.conf
    settings/080-s3.conf
    settings/081-s3.conf.testing
    settings/090-cors.conf
    settings/090-support.conf
    settings/100-admin_look.conf
    settings/110-staff.conf
    settings/111-staff.conf.testing
    settings/120-abc.conf
    settings/121-abc.conf.testing
    settings/130-frontend.conf
    settings/130-frontend.conf.development
    settings/130-frontend.conf.testing
    settings/130-rest_framework.conf
    settings/140-constance.conf
)

NO_CHECK_IMPORTS()

END()
