PY3TEST()

OWNER(g:tools-audit)

INCLUDE(${ARCADIA_ROOT}/antiadblock/postgres_local/recipe/recipe.inc)

ENV(PYTEST_ADDOPTS=-l)
ENV(DJANGO_SETTINGS_MODULE=intranet.audit.src.settings)
ENV(YENV_TYPE=development.unittest)
ENV(YENV_NAME=intranet)

DATA(
    arcadia/intranet/audit/vcr_cassettes
)

NO_CHECK_IMPORTS()

PEERDIR(
    intranet/audit/src
    intranet/audit/src/api_v1
    intranet/audit/src/core
    intranet/audit/src/files
    intranet/audit/src/frontend
    intranet/audit/src/users

    contrib/python/freezegun
    contrib/python/pytest-django
    contrib/python/vcrpy
)

TEST_SRCS(
    api/views/test_actions.py
    api/views/test_count_view.py
    api/views/test_create_view.py
    api/views/test_detail_view.py
    api/views/test_export.py
    api/views/test_export_files.py
    api/views/test_filter_by.py
    api/views/test_filter_data.py
    api/views/test_list_exportview.py
    api/views/test_list_view.py
    api/views/test_metadata.py
    api/views/test_move_controlstep.py
    api/views/test_num_queries.py
    api/views/test_order_by.py
    api/views/test_pagination.py
    api/views/test_permissions.py
    api/views/test_run_controlplan.py
    api/views/test_search_by.py
    api/views/test_suggest.py
    api/conftest.py
    core/test_lookups.py
    users/dao/test_user.py
    users/logic/test_blackbox_result.py
    users/logic/test_get_users.py
    users/logic/test_utils.py
    users/conftest.py
    users/test_middleware.py
)

SIZE(MEDIUM)



END()
