package handler

import (
	"encoding/json"
	"net/http"

	"a.yandex-team.ru/library/go/core/log"
	"a.yandex-team.ru/library/go/core/log/ctxlog"

	"a.yandex-team.ru/intranet/auth-checker/internal/firewall"
)

func GetIPCheckerHandler(logger log.Logger, ipChecker *firewall.IPChecker) http.HandlerFunc {
	return http.HandlerFunc(func(w http.ResponseWriter, r *http.Request) {
		ip := r.URL.Query().Get("ip")

		var isInternal bool
		var err error

		if ip == "" {
			isInternal = false
		} else {
			isInternal, err = ipChecker.IsInternal(r.Context(), ip)
			if err != nil {
				ctxlog.Error(r.Context(), logger, "unable to check ip", log.Error(err), log.String("ip", ip))
				isInternal = false
			}
		}

		Response := struct {
			IsInternal bool `json:"is_internal"`
		}{IsInternal: isInternal}
		response, _ := json.Marshal(&Response)

		w.Header().Set("Content-Type", "application/json")

		_, err = w.Write(response)
		if err != nil {
			logger.Warn("unable to write response", log.Error(err))
		}
	})
}
